/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.analytics.batch.exportimport.internal.engine;

import com.liferay.analytics.batch.exportimport.internal.odata.entity.AnalyticsDXPEntityEntityModel;
import com.liferay.analytics.dxp.entity.rest.dto.v1_0.DXPEntity;
import com.liferay.analytics.dxp.entity.rest.dto.v1_0.converter.DXPEntityDTOConverter;
import com.liferay.analytics.message.storage.model.AnalyticsDeleteMessage;
import com.liferay.analytics.message.storage.service.AnalyticsDeleteMessageLocalService;
import com.liferay.batch.engine.BaseBatchEngineTaskItemDelegate;
import com.liferay.batch.engine.BatchEngineTaskItemDelegate;
import com.liferay.batch.engine.pagination.Page;
import com.liferay.batch.engine.pagination.Pagination;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.TermRangeQuery;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.search.filter.QueryFilter;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.odata.entity.EntityModel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"batch.engine.task.item.delegate.name=analytics-delete-message-analytics-dxp-entities"}, service={BatchEngineTaskItemDelegate.class})
public class AnalyticsDeleteMessageAnalyticsDXPEntityBatchEngineTaskItemDelegate
extends BaseBatchEngineTaskItemDelegate<DXPEntity> {
    @Reference
    private AnalyticsDeleteMessageLocalService _analyticsDeleteMessageLocalService;
    @Reference
    private DXPEntityDTOConverter _dxpEntityDTOConverter;

    public EntityModel getEntityModel(Map<String, List<String>> multivaluedMap) throws Exception {
        return new AnalyticsDXPEntityEntityModel();
    }

    public Page<DXPEntity> read(Filter filter, Pagination pagination, Sort[] sorts, Map<String, Serializable> parameters, String search) throws Exception {
        List analyticsDeleteMessages = null;
        int totalCount = 0;
        Date modifiedDate = this._getModifiedDate(filter);
        if (modifiedDate != null) {
            analyticsDeleteMessages = this._analyticsDeleteMessageLocalService.getAnalyticsDeleteMessages(this.contextCompany.getCompanyId(), modifiedDate, pagination.getStartPosition(), pagination.getEndPosition());
            totalCount = this._analyticsDeleteMessageLocalService.getAnalyticsDeleteMessagesCount(this.contextCompany.getCompanyId(), modifiedDate);
        } else {
            analyticsDeleteMessages = this._analyticsDeleteMessageLocalService.getAnalyticsDeleteMessages(this.contextCompany.getCompanyId(), pagination.getStartPosition(), pagination.getEndPosition());
            totalCount = this._analyticsDeleteMessageLocalService.getAnalyticsDeleteMessagesCount(this.contextCompany.getCompanyId());
        }
        if (ListUtil.isEmpty((List)analyticsDeleteMessages)) {
            return Page.of(Collections.emptyList());
        }
        ArrayList<Object> dxpEntities = new ArrayList<Object>();
        for (AnalyticsDeleteMessage analyticsDeleteMessage : analyticsDeleteMessages) {
            dxpEntities.add(this._dxpEntityDTOConverter.toDTO((Object)analyticsDeleteMessage));
        }
        return Page.of(dxpEntities, (Pagination)pagination, (long)totalCount);
    }

    private Date _getModifiedDate(Filter filter) {
        if (!(filter instanceof QueryFilter)) {
            return null;
        }
        QueryFilter queryFilter = (QueryFilter)filter;
        Query query = queryFilter.getQuery();
        if (!(query instanceof TermRangeQuery)) {
            return null;
        }
        TermRangeQuery termRangeQuery = (TermRangeQuery)query;
        if (!StringUtil.startsWith((String)termRangeQuery.getField(), (String)"modified")) {
            return null;
        }
        String lowerTerm = termRangeQuery.getLowerTerm();
        return new Date(GetterUtil.getLong((String)lowerTerm));
    }
}

