/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.analytics.batch.exportimport.internal.dispatch.executor;

import com.liferay.analytics.batch.exportimport.manager.AnalyticsBatchExportImportManager;
import com.liferay.analytics.dxp.entity.rest.dto.v1_0.DXPEntity;
import com.liferay.dispatch.executor.BaseDispatchTaskExecutor;
import com.liferay.dispatch.executor.DispatchTaskExecutorOutput;
import com.liferay.dispatch.executor.DispatchTaskStatus;
import com.liferay.dispatch.model.DispatchLog;
import com.liferay.dispatch.model.DispatchTrigger;
import com.liferay.dispatch.service.DispatchLogLocalService;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.osgi.service.component.annotations.Reference;

public abstract class BaseAnalyticsDXPEntityExportDispatchTaskExecutor
extends BaseDispatchTaskExecutor {
    @Reference
    protected AnalyticsBatchExportImportManager analyticsBatchExportImportManager;
    @Reference
    protected DispatchLogLocalService dispatchLogLocalService;
    private static final DateFormat _dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");

    public void doExecute(DispatchTrigger dispatchTrigger, DispatchTaskExecutorOutput dispatchTaskExecutorOutput) throws Exception {
        if (!this.shouldExport(dispatchTrigger.getCompanyId())) {
            return;
        }
        DispatchLog dispatchLog = this.dispatchLogLocalService.fetchLatestDispatchLog(dispatchTrigger.getDispatchTriggerId(), DispatchTaskStatus.IN_PROGRESS);
        DispatchLog latestSuccessfulDispatchLog = this.dispatchLogLocalService.fetchLatestDispatchLog(dispatchTrigger.getDispatchTriggerId(), DispatchTaskStatus.SUCCESSFUL);
        Date resourceLastModifiedDate = null;
        if (latestSuccessfulDispatchLog != null) {
            resourceLastModifiedDate = latestSuccessfulDispatchLog.getEndDate();
        }
        this.analyticsBatchExportImportManager.exportToAnalyticsCloud(this.getBatchEngineExportTaskItemDelegateName(), dispatchTrigger.getCompanyId(), null, message -> this._updateDispatchLog(dispatchLog.getDispatchLogId(), dispatchTaskExecutorOutput, (String)message), resourceLastModifiedDate, DXPEntity.class.getName(), dispatchTrigger.getUserId());
    }

    protected abstract String getBatchEngineExportTaskItemDelegateName();

    protected boolean shouldExport(long companyId) {
        return true;
    }

    private void _updateDispatchLog(long dispatchLogId, DispatchTaskExecutorOutput dispatchTaskExecutorOutput, String message) throws PortalException {
        StringBundler sb = new StringBundler(5);
        if (dispatchTaskExecutorOutput.getOutput() != null) {
            sb.append(dispatchTaskExecutorOutput.getOutput());
        }
        sb.append(_dateFormat.format(new Date()));
        sb.append(" ");
        sb.append(message);
        sb.append("\n");
        dispatchTaskExecutorOutput.setOutput(sb.toString());
        this.dispatchLogLocalService.updateDispatchLog(dispatchLogId, new Date(), dispatchTaskExecutorOutput.getError(), dispatchTaskExecutorOutput.getOutput(), DispatchTaskStatus.IN_PROGRESS);
    }
}

