/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.analytics.batch.exportimport.internal;

import com.liferay.analytics.batch.exportimport.AnalyticsDXPEntityBatchExporter;
import com.liferay.dispatch.executor.DispatchTaskClusterMode;
import com.liferay.dispatch.model.DispatchTrigger;
import com.liferay.dispatch.service.DispatchTriggerLocalService;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.Destination;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.service.UserLocalService;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Date;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={AnalyticsDXPEntityBatchExporter.class})
public class AnalyticsDXPEntityBatchExporterImpl
implements AnalyticsDXPEntityBatchExporter {
    private static final String _CRON_EXPRESSION = "0 0 * * * ?";
    private static final String[] _DISPATCH_TRIGGER_NAMES = new String[]{"export-account-entry-analytics-dxp-entities", "export-account-group-analytics-dxp-entities", "export-analytics-association-analytics-dxp-entities", "export-analytics-delete-message-analytics-dxp-entities", "export-expando-column-analytics-dxp-entities", "export-group-analytics-dxp-entities", "export-organization-analytics-dxp-entities", "export-role-analytics-dxp-entities", "export-team-analytics-dxp-entities", "export-user-analytics-dxp-entities", "export-user-group-analytics-dxp-entities"};
    private static final Log _log = LogFactoryUtil.getLog(AnalyticsDXPEntityBatchExporterImpl.class);
    @Reference(target="(destination.name=liferay/dispatch/executor)")
    private Destination _destination;
    @Reference
    private DispatchTriggerLocalService _dispatchTriggerLocalService;
    @Reference
    private UserLocalService _userLocalService;

    public void export(long companyId) throws Exception {
        for (String dispatchTriggerName : _DISPATCH_TRIGGER_NAMES) {
            DispatchTrigger dispatchTrigger = this._dispatchTriggerLocalService.fetchDispatchTrigger(companyId, dispatchTriggerName);
            if (dispatchTrigger == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Unable to find dispatch trigger with name " + dispatchTriggerName));
                }
                return;
            }
            Message message = new Message();
            message.setPayload((Object)JSONUtil.put((String)"dispatchTriggerId", (Object)dispatchTrigger.getDispatchTriggerId()).toString());
            this._destination.send(message);
        }
    }

    public void refreshExportTrigger(long companyId, String dispatchTriggerName) throws Exception {
        DispatchTrigger dispatchTrigger = this._dispatchTriggerLocalService.fetchDispatchTrigger(companyId, dispatchTriggerName);
        if (dispatchTrigger == null) {
            return;
        }
        Date nextFireDate = dispatchTrigger.getNextFireDate();
        Instant instant = nextFireDate.toInstant();
        ZonedDateTime zonedDateTime = instant.atZone(ZoneId.of("UTC"));
        this._dispatchTriggerLocalService.deleteDispatchTrigger(dispatchTrigger);
        this._addDispatchTrigger(companyId, dispatchTriggerName, zonedDateTime.toLocalDateTime());
    }

    public void scheduleExportTriggers(long companyId) throws Exception {
        for (String dispatchTriggerName : _DISPATCH_TRIGGER_NAMES) {
            DispatchTrigger dispatchTrigger = this._dispatchTriggerLocalService.fetchDispatchTrigger(companyId, dispatchTriggerName);
            if (dispatchTrigger != null) continue;
            this._addDispatchTrigger(companyId, dispatchTriggerName, LocalDateTime.now());
        }
    }

    public void unscheduleExportTriggers(long companyId) throws Exception {
        for (String dispatchTriggerName : _DISPATCH_TRIGGER_NAMES) {
            DispatchTrigger dispatchTrigger = this._dispatchTriggerLocalService.fetchDispatchTrigger(companyId, dispatchTriggerName);
            if (dispatchTrigger == null) {
                if (!_log.isDebugEnabled()) continue;
                _log.debug((Object)("Unable to find dispatch trigger with name " + dispatchTriggerName));
                continue;
            }
            this._dispatchTriggerLocalService.deleteDispatchTrigger(dispatchTrigger);
        }
    }

    private DispatchTrigger _addDispatchTrigger(long companyId, String dispatchTriggerName, LocalDateTime localDateTime) throws Exception {
        DispatchTrigger dispatchTrigger = this._dispatchTriggerLocalService.addDispatchTrigger(null, this._userLocalService.getDefaultUserId(companyId), dispatchTriggerName, null, dispatchTriggerName, false);
        return this._dispatchTriggerLocalService.updateDispatchTrigger(dispatchTrigger.getDispatchTriggerId(), true, _CRON_EXPRESSION, DispatchTaskClusterMode.NOT_APPLICABLE, 0, 0, 0, 0, 0, true, false, localDateTime.getMonthValue() - 1, localDateTime.getDayOfMonth(), localDateTime.getYear(), localDateTime.getHour(), localDateTime.getMinute(), "UTC");
    }
}

