/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.analytics.model;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class IdentityContextMessage
implements Serializable {
    private String _browserPluginDetails;
    private String _canvasFingerPrint;
    private boolean _cookiesEnabled;
    private String _dataSourceId;
    private String _dataSourceIdentifier;
    private String _dataSourceIndividualIdentifier;
    private String _domain;
    private String _httpAcceptHeaders;
    private Map<String, String> _identityFields = new HashMap<String, String>();
    private String _language;
    private String _platform;
    private String _protocolVersion;
    private String _screenSizeAndColorDepth;
    private String _systemFonts;
    private String _timezone;
    private boolean _touchSupport;
    private String _userAgent;
    private String _userId;
    private String _webGLFingerPrint;

    public static Builder builder(String dataSourceId) {
        return new Builder(dataSourceId);
    }

    public String getBrowserPluginDetails() {
        return this._browserPluginDetails;
    }

    public String getCanvasFingerPrint() {
        return this._canvasFingerPrint;
    }

    public String getDataSourceId() {
        return this._dataSourceId;
    }

    public String getDataSourceIdentifier() {
        return this._dataSourceIdentifier;
    }

    public String getDataSourceIndividualIdentifier() {
        return this._dataSourceIndividualIdentifier;
    }

    public String getDomain() {
        return this._domain;
    }

    public String getHttpAcceptHeaders() {
        return this._httpAcceptHeaders;
    }

    public Map<String, String> getIdentityFields() {
        return Collections.unmodifiableMap(this._identityFields);
    }

    public String getLanguage() {
        return this._language;
    }

    public String getPlatform() {
        return this._platform;
    }

    public String getProtocolVersion() {
        return this._protocolVersion;
    }

    public String getScreenSizeAndColorDepth() {
        return this._screenSizeAndColorDepth;
    }

    public String getSystemFonts() {
        return this._systemFonts;
    }

    public String getTimezone() {
        return this._timezone;
    }

    public String getUserAgent() {
        return this._userAgent;
    }

    public String getUserId() {
        return this._userId;
    }

    public String getWebGLFingerPrint() {
        return this._webGLFingerPrint;
    }

    public boolean isCookiesEnabled() {
        return this._cookiesEnabled;
    }

    public boolean isTouchSupport() {
        return this._touchSupport;
    }

    private IdentityContextMessage() {
    }

    public static final class Builder {
        private final IdentityContextMessage _identityMessage = new IdentityContextMessage();

        public Builder browserPluginDetails(String browserPluginDetails) {
            this._identityMessage._browserPluginDetails = browserPluginDetails;
            return this;
        }

        public IdentityContextMessage build() {
            return this._identityMessage;
        }

        public Builder canvasFingerPrint(String canvasFingerPrint) {
            this._identityMessage._canvasFingerPrint = canvasFingerPrint;
            return this;
        }

        public Builder cookiesEnabled(boolean cookiesEnabled) {
            this._identityMessage._cookiesEnabled = cookiesEnabled;
            return this;
        }

        public Builder dataSourceIdentifier(String dataSourceIdentifier) {
            this._identityMessage._dataSourceIdentifier = dataSourceIdentifier;
            return this;
        }

        public Builder dataSourceIndividualIdentifier(String dataSourceIndividualIdentifier) {
            this._identityMessage._dataSourceIndividualIdentifier = dataSourceIndividualIdentifier;
            return this;
        }

        public Builder domain(String domain) {
            this._identityMessage._domain = domain;
            return this;
        }

        public Builder httpAcceptHeaders(String httpAcceptHeaders) {
            this._identityMessage._httpAcceptHeaders = httpAcceptHeaders;
            return this;
        }

        public Builder identityFields(Map<String, String> identityFields) {
            this._identityMessage._identityFields = identityFields;
            return this;
        }

        public Builder identityFieldsProperty(String key, String value) {
            this._identityMessage._identityFields.put(key, value);
            return this;
        }

        public Builder language(String language) {
            this._identityMessage._language = language;
            return this;
        }

        public Builder platform(String platform) {
            this._identityMessage._platform = platform;
            return this;
        }

        public Builder protocolVersion(String protocolVersion) {
            this._identityMessage._protocolVersion = protocolVersion;
            return this;
        }

        public Builder screenSizeAndColorDepth(String screenSizeAndColorDepth) {
            this._identityMessage._screenSizeAndColorDepth = screenSizeAndColorDepth;
            return this;
        }

        public Builder systemFonts(String systemFonts) {
            this._identityMessage._systemFonts = systemFonts;
            return this;
        }

        public Builder timezone(String timezone) {
            this._identityMessage._timezone = timezone;
            return this;
        }

        public Builder touchSupport(boolean touchSupport) {
            this._identityMessage._touchSupport = touchSupport;
            return this;
        }

        public Builder userAgent(String userAgent) {
            this._identityMessage._userAgent = userAgent;
            return this;
        }

        public Builder userId(String temporaryUserID) {
            this._identityMessage._userId = temporaryUserID;
            return this;
        }

        public Builder webGLFingerPrint(String webGLFingerPrint) {
            this._identityMessage._webGLFingerPrint = webGLFingerPrint;
            return this;
        }

        protected Builder(String dataSourceId) {
            this._identityMessage._dataSourceId = dataSourceId;
        }
    }
}

