/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.adaptive.media.image.item.selector.internal;

import com.liferay.adaptive.media.image.item.selector.AMImageURLItemSelectorReturnType;
import com.liferay.adaptive.media.image.media.query.Condition;
import com.liferay.adaptive.media.image.media.query.MediaQuery;
import com.liferay.adaptive.media.image.media.query.MediaQueryProvider;
import com.liferay.document.library.kernel.util.DLUtil;
import com.liferay.item.selector.ItemSelectorReturnTypeResolver;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.portletfilerepository.PortletFileRepositoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import java.util.List;
import java.util.stream.Stream;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"service.ranking:Integer=100"}, service={ItemSelectorReturnTypeResolver.class})
public class FileEntryAMImageURLItemSelectorReturnTypeResolver
implements ItemSelectorReturnTypeResolver<AMImageURLItemSelectorReturnType, FileEntry> {
    @Reference
    private MediaQueryProvider _mediaQueryProvider;

    public Class<AMImageURLItemSelectorReturnType> getItemSelectorReturnTypeClass() {
        return AMImageURLItemSelectorReturnType.class;
    }

    public Class<FileEntry> getModelClass() {
        return FileEntry.class;
    }

    public String getValue(FileEntry fileEntry, ThemeDisplay themeDisplay) throws Exception {
        JSONObject fileEntryJSONObject = JSONFactoryUtil.createJSONObject();
        String previewURL = null;
        previewURL = fileEntry.getGroupId() == fileEntry.getRepositoryId() ? DLUtil.getImagePreviewURL((FileEntry)fileEntry, (FileVersion)fileEntry.getFileVersion(), (ThemeDisplay)themeDisplay, (String)"", (boolean)false, (boolean)false) : PortletFileRepositoryUtil.getPortletFileEntryURL((ThemeDisplay)themeDisplay, (FileEntry)fileEntry, (String)"&imagePreview=1", (boolean)false);
        fileEntryJSONObject.put("defaultSource", previewURL);
        fileEntryJSONObject.put("fileEntryId", fileEntry.getFileEntryId());
        JSONArray sourcesArray = JSONFactoryUtil.createJSONArray();
        List mediaQueries = this._mediaQueryProvider.getMediaQueries(fileEntry);
        Stream mediaQueryStream = mediaQueries.stream();
        mediaQueryStream.map(this::_getSourceJSONObject).forEach(arg_0 -> ((JSONArray)sourcesArray).put(arg_0));
        fileEntryJSONObject.put("sources", sourcesArray);
        return fileEntryJSONObject.toString();
    }

    private JSONObject _getSourceJSONObject(MediaQuery mediaQuery) {
        JSONObject sourceJSONObject = JSONFactoryUtil.createJSONObject();
        JSONObject attributesJSONObject = JSONFactoryUtil.createJSONObject();
        for (Condition condition : mediaQuery.getConditions()) {
            attributesJSONObject.put(condition.getAttribute(), condition.getValue());
        }
        sourceJSONObject.put("attributes", attributesJSONObject);
        sourceJSONObject.put("src", mediaQuery.getSrc());
        return sourceJSONObject;
    }
}

