/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.adaptive.media.image.internal.validator;

import com.liferay.adaptive.media.AMAttribute;
import com.liferay.adaptive.media.AdaptiveMedia;
import com.liferay.adaptive.media.image.mime.type.AMImageMimeTypeProvider;
import com.liferay.adaptive.media.image.service.AMImageEntryLocalService;
import com.liferay.adaptive.media.image.size.AMImageSizeProvider;
import com.liferay.adaptive.media.image.validator.AMImageValidator;
import com.liferay.document.library.kernel.model.DLFileEntryMetadata;
import com.liferay.document.library.kernel.service.DLFileEntryMetadataLocalService;
import com.liferay.document.library.kernel.util.RawMetadataProcessor;
import com.liferay.dynamic.data.mapping.form.field.type.DDMFormFieldValueValidationException;
import com.liferay.dynamic.data.mapping.kernel.DDMStructure;
import com.liferay.dynamic.data.mapping.kernel.DDMStructureManager;
import com.liferay.dynamic.data.mapping.model.Value;
import com.liferay.dynamic.data.mapping.storage.DDMFormFieldValue;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.dynamic.data.mapping.storage.StorageEngine;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PropsValues;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={AMImageValidator.class})
public class AMImageValidatorImpl
implements AMImageValidator {
    private static final Log _log = LogFactoryUtil.getLog(AMImageValidatorImpl.class);
    @Reference
    private AMImageEntryLocalService _amImageEntryLocalService;
    @Reference
    private AMImageMimeTypeProvider _amImageMimeTypeProvider;
    @Reference
    private AMImageSizeProvider _amImageSizeProvider;
    @Reference
    private DDMStructureManager _ddmStructureManager;
    @Reference
    private DLFileEntryMetadataLocalService _dlFileEntryMetadataLocalService;
    @Reference
    private Portal _portal;
    @Reference
    private StorageEngine _storageEngine;

    public <T> boolean isProcessingRequired(AdaptiveMedia<T> adaptiveMedia, FileVersion fileVersion) {
        if (!this.isProcessingSupported(fileVersion)) {
            return false;
        }
        Optional configurationUuidOptional = adaptiveMedia.getValueOptional(AMAttribute.getConfigurationUuidAMAttribute());
        if (!configurationUuidOptional.isPresent()) {
            return true;
        }
        String configurationUuid = (String)configurationUuidOptional.get();
        return !this._amImageEntryLocalService.hasAMImageEntryContent(configurationUuid, fileVersion);
    }

    public boolean isProcessingSupported(FileVersion fileVersion) {
        return this.isValid(fileVersion) && !Objects.equals(fileVersion.getMimeType(), "image/svg+xml");
    }

    public boolean isProcessingSupported(String mimeType) {
        return !StringUtil.equalsIgnoreCase((String)mimeType, (String)"image/svg+xml");
    }

    public boolean isValid(FileVersion fileVersion) {
        long imageMaxSize = this._amImageSizeProvider.getImageMaxSize();
        if (imageMaxSize != -1L && (imageMaxSize == 0L || fileVersion.getSize() == 0L || fileVersion.getSize() >= imageMaxSize)) {
            return false;
        }
        return this._amImageMimeTypeProvider.isMimeTypeSupported(fileVersion.getMimeType()) && this._isFileVersionStoredMetadataSupported(fileVersion);
    }

    protected void setAMImageEntryLocalService(AMImageEntryLocalService amImageEntryLocalService) {
        this._amImageEntryLocalService = amImageEntryLocalService;
    }

    private boolean _isFileVersionStoredMetadataSupported(FileVersion fileVersion) {
        List ddmStructures = this._ddmStructureManager.getClassStructures(fileVersion.getCompanyId(), this._portal.getClassNameId(RawMetadataProcessor.class), 0);
        for (DDMStructure ddmStructure : ddmStructures) {
            DLFileEntryMetadata fileEntryMetadata = this._dlFileEntryMetadataLocalService.fetchFileEntryMetadata(ddmStructure.getStructureId(), fileVersion.getFileVersionId());
            if (fileEntryMetadata == null) continue;
            try {
                DDMFormValues ddmFormValues = this._storageEngine.getDDMFormValues(fileEntryMetadata.getDDMStorageId());
                Map ddmFormFieldValuesMap = ddmFormValues.getDDMFormFieldValuesMap(true);
                for (Map.Entry entry : ddmFormFieldValuesMap.entrySet()) {
                    if (Objects.equals(entry.getKey(), "TIFF_IMAGE_LENGTH") && !this._isValidDimension((List)entry.getValue(), PropsValues.IMAGE_TOOL_IMAGE_MAX_HEIGHT)) {
                        return false;
                    }
                    if (!Objects.equals(entry.getKey(), "TIFF_IMAGE_WIDTH") || this._isValidDimension((List)entry.getValue(), PropsValues.IMAGE_TOOL_IMAGE_MAX_WIDTH)) continue;
                    return false;
                }
            }
            catch (DDMFormFieldValueValidationException ddmFormFieldValueValidationException) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)("Unable to validate dynamic data mapping form values for file version " + fileVersion.getFileVersionId()));
                }
                if (!_log.isDebugEnabled()) continue;
                _log.debug((Throwable)ddmFormFieldValueValidationException);
            }
            catch (PortalException portalException) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)StringBundler.concat((Object[])new Object[]{"Unable to find dynamic data mapping form values ", "for ", fileVersion.getFileVersionId(), " in structure ", ddmStructure.getStructureKey()}));
                }
                if (!_log.isDebugEnabled()) continue;
                _log.debug((Throwable)portalException);
            }
        }
        return true;
    }

    private boolean _isValidDimension(List<DDMFormFieldValue> ddmFormFieldValues, long imageToolImageMaxValue) throws DDMFormFieldValueValidationException {
        if (imageToolImageMaxValue <= 0L) {
            return true;
        }
        DDMFormFieldValue ddmFormFieldValue = ddmFormFieldValues.get(0);
        Value value = ddmFormFieldValue.getValue();
        String valueString = value.getString(value.getDefaultLocale());
        if (Validator.isNull((String)valueString)) {
            Locale availableLocale;
            Iterator iterator = value.getAvailableLocales().iterator();
            while (iterator.hasNext() && !Validator.isNotNull((String)(valueString = value.getString(availableLocale = (Locale)iterator.next())))) {
            }
        }
        if (Validator.isNull((String)valueString)) {
            throw new DDMFormFieldValueValidationException();
        }
        return Long.valueOf(valueString) < imageToolImageMaxValue;
    }
}

