/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.adaptive.media.image.internal.scaler;

import com.liferay.adaptive.media.exception.AMRuntimeException;
import com.liferay.adaptive.media.image.configuration.AMImageConfigurationEntry;
import com.liferay.adaptive.media.image.internal.scaler.AMImageScaledImageImpl;
import com.liferay.adaptive.media.image.scaler.AMImageScaledImage;
import com.liferay.adaptive.media.image.scaler.AMImageScaler;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.image.ImageBag;
import com.liferay.portal.kernel.image.ImageMagick;
import com.liferay.portal.kernel.image.ImageTool;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.util.GetterUtil;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.Future;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"mime.type=image/heic", "mime.type=image/webp"}, service={AMImageScaler.class})
public class AMImageMagickImageScaler
implements AMImageScaler {
    @Reference
    private com.liferay.portal.kernel.util.File _file;
    @Reference
    private ImageMagick _imageMagick;
    @Reference
    private ImageTool _imageTool;

    public boolean isEnabled() {
        return this._imageMagick.isEnabled();
    }

    public AMImageScaledImage scaleImage(FileVersion fileVersion, AMImageConfigurationEntry amImageConfigurationEntry) {
        File imageFile = null;
        File scaledImageFile = null;
        try {
            imageFile = this._getFile(fileVersion);
            scaledImageFile = this._scaleAndConvertToPNG(amImageConfigurationEntry, imageFile);
            if (!scaledImageFile.exists()) {
                throw new AMRuntimeException.IOException("Unable to scale image using ImageMagick");
            }
            ImageBag imageBag = this._imageTool.read(scaledImageFile);
            RenderedImage renderedImage = imageBag.getRenderedImage();
            AMImageScaledImageImpl aMImageScaledImageImpl = new AMImageScaledImageImpl(this._imageTool.getBytes(renderedImage, imageBag.getType()), renderedImage.getHeight(), "image/png", renderedImage.getWidth());
            return aMImageScaledImageImpl;
        }
        catch (Exception exception) {
            throw new AMRuntimeException.IOException(StringBundler.concat((Object[])new Object[]{"Unable to scale file entry ", fileVersion.getFileEntryId(), " to match adaptive media configuration ", amImageConfigurationEntry.getUUID()}), (Throwable)exception);
        }
        finally {
            if (imageFile != null) {
                imageFile.delete();
            }
            if (scaledImageFile != null) {
                scaledImageFile.delete();
            }
        }
    }

    private File _getFile(FileVersion fileVersion) throws IOException, PortalException {
        try (InputStream inputStream = fileVersion.getContentStream(false);){
            File file = this._file.createTempFile(inputStream);
            return file;
        }
    }

    private String _getResizeArg(AMImageConfigurationEntry amImageConfigurationEntry) {
        Map properties = amImageConfigurationEntry.getProperties();
        int maxHeight = GetterUtil.getInteger((String)((String)properties.get("max-height")));
        int maxWidth = GetterUtil.getInteger((String)((String)properties.get("max-width")));
        if (maxHeight > 0 && maxWidth > 0) {
            return StringBundler.concat((Object[])new Object[]{maxWidth, "x", maxHeight, ">"});
        }
        return null;
    }

    private File _scaleAndConvertToPNG(AMImageConfigurationEntry amImageConfigurationEntry, File imageFile) throws Exception {
        File scaledImageFile = this._file.createTempFile("png");
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add(imageFile.getAbsolutePath());
        String resizeArg = this._getResizeArg(amImageConfigurationEntry);
        if (resizeArg != null) {
            arguments.add("-resize");
            arguments.add(resizeArg);
        }
        arguments.add(scaledImageFile.getAbsolutePath());
        Future future = this._imageMagick.convert(arguments);
        future.get();
        return scaledImageFile;
    }
}

