/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.adaptive.media.image.internal.scaler;

import com.liferay.adaptive.media.exception.AMRuntimeException;
import com.liferay.adaptive.media.image.configuration.AMImageConfigurationEntry;
import com.liferay.adaptive.media.image.internal.processor.util.TiffOrientationTransformer;
import com.liferay.adaptive.media.image.internal.scaler.AMImageScaledImageImpl;
import com.liferay.adaptive.media.image.internal.util.RenderedImageUtil;
import com.liferay.adaptive.media.image.scaler.AMImageScaledImage;
import com.liferay.adaptive.media.image.scaler.AMImageScaler;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.image.ImageTool;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.util.GetterUtil;
import java.awt.image.RenderedImage;
import java.io.InputStream;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"mime.type=*"}, service={AMImageScaler.class})
public class AMDefaultImageScaler
implements AMImageScaler {
    @Reference
    private ImageTool _imageTool;

    public AMImageScaledImage scaleImage(FileVersion fileVersion, AMImageConfigurationEntry amImageConfigurationEntry) {
        try {
            RenderedImage renderedImage = TiffOrientationTransformer.transform(() -> this._getInputStream(fileVersion));
            Map properties = amImageConfigurationEntry.getProperties();
            int maxHeight = GetterUtil.getInteger((String)((String)properties.get("max-height")));
            int maxWidth = GetterUtil.getInteger((String)((String)properties.get("max-width")));
            RenderedImage scaledRenderedImage = this._imageTool.scale(renderedImage, maxHeight, maxWidth);
            return new AMImageScaledImageImpl(RenderedImageUtil.getRenderedImageContentStream(scaledRenderedImage, fileVersion.getMimeType()), scaledRenderedImage.getHeight(), fileVersion.getMimeType(), scaledRenderedImage.getWidth());
        }
        catch (AMRuntimeException.IOException | PortalException exception) {
            throw new AMRuntimeException.IOException(StringBundler.concat((Object[])new Object[]{"Unable to scale file entry ", fileVersion.getFileEntryId(), " to match adaptive media configuration ", amImageConfigurationEntry.getUUID()}), exception);
        }
    }

    private InputStream _getInputStream(FileVersion fileVersion) {
        try {
            return fileVersion.getContentStream(false);
        }
        catch (PortalException portalException) {
            throw new AMRuntimeException.IOException((Throwable)portalException);
        }
    }
}

