/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.adaptive.media.image.internal.finder;

import com.liferay.adaptive.media.AMAttribute;
import com.liferay.adaptive.media.AMDistanceComparator;
import com.liferay.adaptive.media.AdaptiveMedia;
import com.liferay.adaptive.media.exception.AMRuntimeException;
import com.liferay.adaptive.media.finder.AMFinder;
import com.liferay.adaptive.media.finder.AMQuery;
import com.liferay.adaptive.media.image.configuration.AMImageConfigurationEntry;
import com.liferay.adaptive.media.image.configuration.AMImageConfigurationHelper;
import com.liferay.adaptive.media.image.finder.AMImageFinder;
import com.liferay.adaptive.media.image.finder.AMImageQueryBuilder;
import com.liferay.adaptive.media.image.internal.configuration.AMImageAttributeMapping;
import com.liferay.adaptive.media.image.internal.finder.AMImageQueryBuilderImpl;
import com.liferay.adaptive.media.image.internal.processor.AMImage;
import com.liferay.adaptive.media.image.mime.type.AMImageMimeTypeProvider;
import com.liferay.adaptive.media.image.model.AMImageEntry;
import com.liferay.adaptive.media.image.processor.AMImageAttribute;
import com.liferay.adaptive.media.image.processor.AMImageProcessor;
import com.liferay.adaptive.media.image.service.AMImageEntryLocalService;
import com.liferay.adaptive.media.image.url.AMImageURLFactory;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.repository.model.FileVersion;
import java.net.URI;
import java.util.Collection;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"model.class.name=com.liferay.portal.kernel.repository.model.FileVersion"}, service={AMFinder.class, AMImageFinder.class})
public class AMImageFinderImpl
implements AMImageFinder {
    @Reference
    private AMImageConfigurationHelper _amImageConfigurationHelper;
    @Reference
    private AMImageEntryLocalService _amImageEntryLocalService;
    @Reference
    private AMImageMimeTypeProvider _amImageMimeTypeProvider;
    @Reference
    private AMImageURLFactory _amImageURLFactory;

    public Stream<AdaptiveMedia<AMImageProcessor>> getAdaptiveMediaStream(Function<AMImageQueryBuilder, AMQuery<FileVersion, AMImageProcessor>> amImageQueryBuilderFunction) throws PortalException {
        if (amImageQueryBuilderFunction == null) {
            throw new IllegalArgumentException("Adaptive media image query builder is null");
        }
        AMImageQueryBuilderImpl amImageQueryBuilderImpl = new AMImageQueryBuilderImpl();
        AMQuery<FileVersion, AMImageProcessor> amQuery = amImageQueryBuilderFunction.apply(amImageQueryBuilderImpl);
        if (amQuery != AMImageQueryBuilderImpl.AM_QUERY) {
            throw new IllegalArgumentException("Only queries built by the provided query builder are valid");
        }
        FileVersion fileVersion = amImageQueryBuilderImpl.getFileVersion();
        if (!this._amImageMimeTypeProvider.isMimeTypeSupported(fileVersion.getMimeType())) {
            return Stream.empty();
        }
        String mimeType = fileVersion.getMimeType();
        if (mimeType.equals("image/svg+xml")) {
            return Stream.of(this._createRawAdaptiveMedia(fileVersion));
        }
        BiFunction<FileVersion, AMImageConfigurationEntry, URI> uriFactory = this._getURIFactory(amImageQueryBuilderImpl);
        AMImageQueryBuilder.ConfigurationStatus configurationStatus = amImageQueryBuilderImpl.getConfigurationStatus();
        Collection amImageConfigurationEntries = this._amImageConfigurationHelper.getAMImageConfigurationEntries(fileVersion.getCompanyId(), configurationStatus.getPredicate());
        Predicate<AMImageConfigurationEntry> filter = amImageQueryBuilderImpl.getConfigurationEntryFilter();
        AMDistanceComparator<AdaptiveMedia<AMImageProcessor>> amDistanceComparator = amImageQueryBuilderImpl.getAMDistanceComparator();
        Stream amImageConfigurationEntryStream = amImageConfigurationEntries.stream();
        return amImageConfigurationEntryStream.filter(amImageConfigurationEntry -> filter.test((AMImageConfigurationEntry)amImageConfigurationEntry) && this._hasAdaptiveMedia(fileVersion, (AMImageConfigurationEntry)amImageConfigurationEntry)).map(amImageConfigurationEntry -> this._createMedia(fileVersion, uriFactory, (AMImageConfigurationEntry)amImageConfigurationEntry)).sorted(amDistanceComparator.toComparator());
    }

    private AdaptiveMedia<AMImageProcessor> _createMedia(FileVersion fileVersion, BiFunction<FileVersion, AMImageConfigurationEntry, URI> uriFactory, AMImageConfigurationEntry amImageConfigurationEntry) {
        Map properties = amImageConfigurationEntry.getProperties();
        AMAttribute configurationUuidAMAttribute = AMAttribute.getConfigurationUuidAMAttribute();
        properties.put(configurationUuidAMAttribute.getName(), amImageConfigurationEntry.getUUID());
        AMAttribute fileNameAMAttribute = AMAttribute.getFileNameAMAttribute();
        properties.put(fileNameAMAttribute.getName(), fileVersion.getFileName());
        AMImageEntry amImageEntry = this._amImageEntryLocalService.fetchAMImageEntry(amImageConfigurationEntry.getUUID(), fileVersion.getFileVersionId());
        if (amImageEntry != null) {
            AMAttribute imageHeightAMAttribute = AMImageAttribute.AM_IMAGE_ATTRIBUTE_HEIGHT;
            properties.put(imageHeightAMAttribute.getName(), String.valueOf(amImageEntry.getHeight()));
            AMAttribute imageWidthAMAttribute = AMImageAttribute.AM_IMAGE_ATTRIBUTE_WIDTH;
            properties.put(imageWidthAMAttribute.getName(), String.valueOf(amImageEntry.getWidth()));
            AMAttribute contentTypeAMAttribute = AMAttribute.getContentTypeAMAttribute();
            properties.put(contentTypeAMAttribute.getName(), amImageEntry.getMimeType());
            AMAttribute contentLengthAMAttribute = AMAttribute.getContentLengthAMAttribute();
            properties.put(contentLengthAMAttribute.getName(), String.valueOf(amImageEntry.getSize()));
        }
        AMImageAttributeMapping amImageAttributeMapping = AMImageAttributeMapping.fromProperties(properties);
        return new AMImage(() -> this._amImageEntryLocalService.getAMImageEntryContentStream(amImageConfigurationEntry, fileVersion), amImageAttributeMapping, uriFactory.apply(fileVersion, amImageConfigurationEntry));
    }

    private AdaptiveMedia<AMImageProcessor> _createRawAdaptiveMedia(FileVersion fileVersion) {
        return new AMImage(() -> {
            try {
                return fileVersion.getContentStream(false);
            }
            catch (PortalException portalException) {
                throw new AMRuntimeException((Throwable)portalException);
            }
        }, AMImageAttributeMapping.fromFileVersion(fileVersion), null);
    }

    private BiFunction<FileVersion, AMImageConfigurationEntry, URI> _getURIFactory(AMImageQueryBuilderImpl amImageQueryBuilderImpl) {
        if (amImageQueryBuilderImpl.hasFileVersion()) {
            return (arg_0, arg_1) -> ((AMImageURLFactory)this._amImageURLFactory).createFileVersionURL(arg_0, arg_1);
        }
        return (arg_0, arg_1) -> ((AMImageURLFactory)this._amImageURLFactory).createFileEntryURL(arg_0, arg_1);
    }

    private boolean _hasAdaptiveMedia(FileVersion fileVersion, AMImageConfigurationEntry amImageConfigurationEntry) {
        AMImageEntry amImageEntry = this._amImageEntryLocalService.fetchAMImageEntry(amImageConfigurationEntry.getUUID(), fileVersion.getFileVersionId());
        return amImageEntry != null;
    }
}

