/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.adaptive.media.image.internal.configuration;

import com.liferay.adaptive.media.exception.AMImageConfigurationException;
import com.liferay.adaptive.media.exception.AMRuntimeException;
import com.liferay.adaptive.media.image.configuration.AMImageConfigurationEntry;
import com.liferay.adaptive.media.image.configuration.AMImageConfigurationHelper;
import com.liferay.adaptive.media.image.internal.configuration.AMImageCompanyConfiguration;
import com.liferay.adaptive.media.image.internal.configuration.AMImageConfigurationEntryImpl;
import com.liferay.adaptive.media.image.internal.configuration.AMImageConfigurationEntryParser;
import com.liferay.adaptive.media.image.service.AMImageEntryLocalService;
import com.liferay.portal.kernel.cache.MultiVMPool;
import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.cache.PortalCacheHelperUtil;
import com.liferay.portal.kernel.messaging.Destination;
import com.liferay.portal.kernel.messaging.DestinationConfiguration;
import com.liferay.portal.kernel.messaging.DestinationFactory;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageBus;
import com.liferay.portal.kernel.settings.CompanyServiceSettingsLocator;
import com.liferay.portal.kernel.settings.ModifiableSettings;
import com.liferay.portal.kernel.settings.PortletPreferencesSettings;
import com.liferay.portal.kernel.settings.Settings;
import com.liferay.portal.kernel.settings.SettingsException;
import com.liferay.portal.kernel.settings.SettingsFactoryUtil;
import com.liferay.portal.kernel.settings.SettingsLocator;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.portlet.PortletPreferences;
import javax.portlet.ValidatorException;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={AMImageConfigurationHelper.class})
public class AMImageConfigurationHelperImpl
implements AMImageConfigurationHelper {
    private static final Pattern _positiveNumberPattern = Pattern.compile("\\d*[1-9]\\d*");
    private static final Pattern _uuidPattern = Pattern.compile("^(?:\\w|-)+$");
    @Reference
    private AMImageConfigurationEntryParser _amImageConfigurationEntryParser;
    @Reference
    private AMImageEntryLocalService _amImageEntryLocalService;
    @Reference
    private DestinationFactory _destinationFactory;
    private ServiceRegistration<Destination> _destinationServiceRegistration;
    @Reference
    private MessageBus _messageBus;
    @Reference
    private MultiVMPool _multiVMPool;
    private PortalCache<Long, Serializable> _portalCache;

    public AMImageConfigurationEntry addAMImageConfigurationEntry(long companyId, String name, String description, String uuid, Map<String, String> properties) throws AMImageConfigurationException, IOException {
        this._checkName(name);
        this._checkProperties(properties);
        this._normalizeProperties(properties);
        this._checkUuid(uuid);
        Collection<AMImageConfigurationEntry> amImageConfigurationEntries = this.getAMImageConfigurationEntries(companyId, amImageConfigurationEntry -> true);
        this._checkDuplicatesName(amImageConfigurationEntries, name);
        this._checkDuplicatesUuid(amImageConfigurationEntries, uuid);
        ArrayList<AMImageConfigurationEntry> updatedAMImageConfigurationEntries = new ArrayList<AMImageConfigurationEntry>(amImageConfigurationEntries);
        updatedAMImageConfigurationEntries.removeIf(amImageConfigurationEntry -> uuid.equals(amImageConfigurationEntry.getUUID()));
        AMImageConfigurationEntryImpl amImageConfigurationEntry2 = new AMImageConfigurationEntryImpl(name, description, uuid, properties, true);
        updatedAMImageConfigurationEntries.add(amImageConfigurationEntry2);
        this._updateConfiguration(companyId, updatedAMImageConfigurationEntries);
        this._triggerConfigurationEvent(amImageConfigurationEntry2);
        return amImageConfigurationEntry2;
    }

    public void deleteAMImageConfigurationEntry(long companyId, String uuid) throws AMImageConfigurationException.InvalidStateAMImageConfigurationException, IOException {
        Optional<AMImageConfigurationEntry> amImageConfigurationEntryOptional = this.getAMImageConfigurationEntry(companyId, uuid);
        if (!amImageConfigurationEntryOptional.isPresent()) {
            return;
        }
        AMImageConfigurationEntry amImageConfigurationEntry = amImageConfigurationEntryOptional.get();
        if (amImageConfigurationEntry.isEnabled()) {
            throw new AMImageConfigurationException.InvalidStateAMImageConfigurationException();
        }
        this.forceDeleteAMImageConfigurationEntry(companyId, uuid);
    }

    public void disableAMImageConfigurationEntry(long companyId, String uuid) throws IOException {
        Optional<AMImageConfigurationEntry> amImageConfigurationEntryOptional = this.getAMImageConfigurationEntry(companyId, uuid);
        if (!amImageConfigurationEntryOptional.isPresent()) {
            return;
        }
        AMImageConfigurationEntry amImageConfigurationEntry = amImageConfigurationEntryOptional.get();
        if (!amImageConfigurationEntry.isEnabled()) {
            return;
        }
        Collection<AMImageConfigurationEntry> amImageConfigurationEntries = this.getAMImageConfigurationEntries(companyId, curConfigurationEntry -> true);
        ArrayList<AMImageConfigurationEntry> updatedAMImageConfigurationEntries = new ArrayList<AMImageConfigurationEntry>(amImageConfigurationEntries);
        updatedAMImageConfigurationEntries.removeIf(curConfigurationEntry -> uuid.equals(curConfigurationEntry.getUUID()));
        AMImageConfigurationEntryImpl newAMImageConfigurationEntry = new AMImageConfigurationEntryImpl(amImageConfigurationEntry.getName(), amImageConfigurationEntry.getDescription(), amImageConfigurationEntry.getUUID(), amImageConfigurationEntry.getProperties(), false);
        updatedAMImageConfigurationEntries.add(newAMImageConfigurationEntry);
        this._updateConfiguration(companyId, updatedAMImageConfigurationEntries);
        this._triggerConfigurationEvent(amImageConfigurationEntry);
    }

    public void enableAMImageConfigurationEntry(long companyId, String uuid) throws IOException {
        Optional<AMImageConfigurationEntry> amImageConfigurationEntryOptional = this.getAMImageConfigurationEntry(companyId, uuid);
        if (!amImageConfigurationEntryOptional.isPresent()) {
            return;
        }
        AMImageConfigurationEntry amImageConfigurationEntry = amImageConfigurationEntryOptional.get();
        if (amImageConfigurationEntry.isEnabled()) {
            return;
        }
        Collection<AMImageConfigurationEntry> amImageConfigurationEntries = this.getAMImageConfigurationEntries(companyId, curConfigurationEntry -> true);
        ArrayList<AMImageConfigurationEntry> updatedAMImageConfigurationEntries = new ArrayList<AMImageConfigurationEntry>(amImageConfigurationEntries);
        updatedAMImageConfigurationEntries.removeIf(curConfigurationEntry -> uuid.equals(curConfigurationEntry.getUUID()));
        AMImageConfigurationEntryImpl newAMImageConfigurationEntry = new AMImageConfigurationEntryImpl(amImageConfigurationEntry.getName(), amImageConfigurationEntry.getDescription(), amImageConfigurationEntry.getUUID(), amImageConfigurationEntry.getProperties(), true);
        updatedAMImageConfigurationEntries.add(newAMImageConfigurationEntry);
        this._updateConfiguration(companyId, updatedAMImageConfigurationEntries);
        this._triggerConfigurationEvent(amImageConfigurationEntry);
    }

    public void forceDeleteAMImageConfigurationEntry(long companyId, String uuid) throws IOException {
        Optional<AMImageConfigurationEntry> amImageConfigurationEntryOptional = this.getAMImageConfigurationEntry(companyId, uuid);
        if (!amImageConfigurationEntryOptional.isPresent()) {
            return;
        }
        AMImageConfigurationEntry amImageConfigurationEntry = amImageConfigurationEntryOptional.get();
        this._amImageEntryLocalService.deleteAMImageEntries(companyId, amImageConfigurationEntry);
        Collection<AMImageConfigurationEntry> amImageConfigurationEntries = this.getAMImageConfigurationEntries(companyId, curConfigurationEntry -> true);
        ArrayList<AMImageConfigurationEntry> updatedAMImageConfigurationEntries = new ArrayList<AMImageConfigurationEntry>(amImageConfigurationEntries);
        updatedAMImageConfigurationEntries.removeIf(curConfigurationEntry -> uuid.equals(curConfigurationEntry.getUUID()));
        this._updateConfiguration(companyId, updatedAMImageConfigurationEntries);
        this._triggerConfigurationEvent(amImageConfigurationEntry);
    }

    public Collection<AMImageConfigurationEntry> getAMImageConfigurationEntries(long companyId) {
        Stream<AMImageConfigurationEntry> amImageConfigurationEntryStream = this._getAMImageConfigurationEntries(companyId);
        return amImageConfigurationEntryStream.filter(AMImageConfigurationEntry::isEnabled).sorted(Comparator.comparing(AMImageConfigurationEntry::getName)).collect(Collectors.toList());
    }

    public Collection<AMImageConfigurationEntry> getAMImageConfigurationEntries(long companyId, Predicate<? super AMImageConfigurationEntry> predicate) {
        Stream<AMImageConfigurationEntry> amImageConfigurationEntryStream = this._getAMImageConfigurationEntries(companyId);
        return amImageConfigurationEntryStream.filter(predicate).sorted(Comparator.comparing(AMImageConfigurationEntry::getName)).collect(Collectors.toList());
    }

    public Optional<AMImageConfigurationEntry> getAMImageConfigurationEntry(long companyId, String configurationEntryUUID) {
        Stream<AMImageConfigurationEntry> amImageConfigurationEntryStream = this._getAMImageConfigurationEntries(companyId);
        return amImageConfigurationEntryStream.filter(amImageConfigurationEntry -> configurationEntryUUID.equals(amImageConfigurationEntry.getUUID())).findFirst();
    }

    public AMImageConfigurationEntry updateAMImageConfigurationEntry(long companyId, String oldUuid, String name, String description, String newUuid, Map<String, String> properties) throws AMImageConfigurationException, IOException {
        this._checkName(name);
        this._checkProperties(properties);
        this._normalizeProperties(properties);
        this._checkUuid(newUuid);
        Collection<AMImageConfigurationEntry> amImageConfigurationEntries = this.getAMImageConfigurationEntries(companyId, amImageConfigurationEntry -> true);
        Stream<AMImageConfigurationEntry> amImageConfigurationEntryStream = amImageConfigurationEntries.stream();
        Optional<AMImageConfigurationEntry> oldAMImageConfigurationEntryOptional = amImageConfigurationEntryStream.filter(amImageConfigurationEntry -> oldUuid.equals(amImageConfigurationEntry.getUUID())).findFirst();
        AMImageConfigurationEntry oldAMImageConfigurationEntry = oldAMImageConfigurationEntryOptional.orElseThrow(() -> new AMImageConfigurationException.NoSuchAMImageConfigurationException("{uuid=" + oldUuid + "}"));
        if (!name.equals(oldAMImageConfigurationEntry.getName())) {
            this._checkDuplicatesName(amImageConfigurationEntries, name);
        }
        if (!oldUuid.equals(newUuid)) {
            this._checkDuplicatesUuid(amImageConfigurationEntries, newUuid);
        }
        ArrayList<AMImageConfigurationEntry> updatedAMImageConfigurationEntries = new ArrayList<AMImageConfigurationEntry>(amImageConfigurationEntries);
        updatedAMImageConfigurationEntries.removeIf(amImageConfigurationEntry -> oldUuid.equals(amImageConfigurationEntry.getUUID()));
        AMImageConfigurationEntryImpl amImageConfigurationEntry2 = new AMImageConfigurationEntryImpl(name, description, newUuid, properties, oldAMImageConfigurationEntry.isEnabled());
        updatedAMImageConfigurationEntries.add(amImageConfigurationEntry2);
        this._updateConfiguration(companyId, updatedAMImageConfigurationEntries);
        this._triggerConfigurationEvent(new AMImageConfigurationEntry[]{oldAMImageConfigurationEntry, amImageConfigurationEntry2});
        return amImageConfigurationEntry2;
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        DestinationConfiguration destinationConfiguration = new DestinationConfiguration("synchronous", "liferay/adaptive_media_image_configuration");
        Destination destination = this._destinationFactory.createDestination(destinationConfiguration);
        this._destinationServiceRegistration = bundleContext.registerService(Destination.class, (Object)destination, MapUtil.singletonDictionary((Object)"destination.name", (Object)destination.getName()));
        this._portalCache = this._multiVMPool.getPortalCache(AMImageConfigurationHelperImpl.class.getName());
    }

    @Deactivate
    protected void deactivate() {
        this._destinationServiceRegistration.unregister();
        this._multiVMPool.removePortalCache(AMImageConfigurationHelperImpl.class.getName());
    }

    private void _checkDuplicatesName(Collection<AMImageConfigurationEntry> amImageConfigurationEntries, String name) throws AMImageConfigurationException {
        Stream<AMImageConfigurationEntry> amImageConfigurationEntryStream = amImageConfigurationEntries.stream();
        Optional<AMImageConfigurationEntry> duplicateNameAMImageConfigurationEntryOptional = amImageConfigurationEntryStream.filter(amImageConfigurationEntry -> name.equals(amImageConfigurationEntry.getName())).findFirst();
        if (duplicateNameAMImageConfigurationEntryOptional.isPresent()) {
            throw new AMImageConfigurationException.DuplicateAMImageConfigurationNameException();
        }
    }

    private void _checkDuplicatesUuid(Collection<AMImageConfigurationEntry> amImageConfigurationEntries, String uuid) throws AMImageConfigurationException {
        Stream<AMImageConfigurationEntry> amImageConfigurationEntryStream = amImageConfigurationEntries.stream();
        Optional<AMImageConfigurationEntry> duplicateUuidAMImageConfigurationEntryOptional = amImageConfigurationEntryStream.filter(amImageConfigurationEntry -> uuid.equals(amImageConfigurationEntry.getUUID())).findFirst();
        if (duplicateUuidAMImageConfigurationEntryOptional.isPresent()) {
            throw new AMImageConfigurationException.DuplicateAMImageConfigurationUuidException();
        }
    }

    private void _checkName(String name) throws AMImageConfigurationException {
        if (Validator.isNull((String)name)) {
            throw new AMImageConfigurationException.InvalidNameException();
        }
    }

    private void _checkProperties(Map<String, String> properties) throws AMImageConfigurationException {
        String maxHeightString = properties.get("max-height");
        if (Validator.isNotNull((String)maxHeightString) && !maxHeightString.equals("0") && !this._isPositiveNumber(maxHeightString)) {
            throw new AMImageConfigurationException.InvalidHeightException();
        }
        String maxWidthString = properties.get("max-width");
        if (Validator.isNotNull((String)maxWidthString) && !maxWidthString.equals("0") && !this._isPositiveNumber(maxWidthString)) {
            throw new AMImageConfigurationException.InvalidWidthException();
        }
        if ((Validator.isNull((String)maxHeightString) || maxHeightString.equals("0")) && (Validator.isNull((String)maxWidthString) || maxWidthString.equals("0"))) {
            throw new AMImageConfigurationException.RequiredWidthOrHeightException();
        }
    }

    private void _checkUuid(String uuid) throws AMImageConfigurationException {
        if (Validator.isNull((String)uuid)) {
            throw new AMImageConfigurationException.InvalidUuidException();
        }
        Matcher matcher = _uuidPattern.matcher(uuid);
        if (!matcher.matches()) {
            throw new AMImageConfigurationException.InvalidUuidException();
        }
    }

    private Stream<AMImageConfigurationEntry> _getAMImageConfigurationEntries(long companyId) {
        ArrayList amImageConfigurationEntries = (ArrayList)this._portalCache.get((Serializable)Long.valueOf(companyId));
        if (amImageConfigurationEntries != null) {
            return amImageConfigurationEntries.stream();
        }
        try {
            Settings settings = SettingsFactoryUtil.getSettings((SettingsLocator)new CompanyServiceSettingsLocator(companyId, AMImageCompanyConfiguration.class.getName()));
            Optional<String[]> nullableImageVariantsOptional = this._getNullableImageVariants(settings);
            String[] imageVariants = nullableImageVariantsOptional.orElseGet(() -> settings.getValues("imageVariants", new String[0]));
            amImageConfigurationEntries = Stream.of(imageVariants).map(this._amImageConfigurationEntryParser::parse).collect(Collectors.toCollection(ArrayList::new));
            PortalCacheHelperUtil.putWithoutReplicator(this._portalCache, (Serializable)Long.valueOf(companyId), (Object)amImageConfigurationEntries);
            return amImageConfigurationEntries.stream();
        }
        catch (SettingsException settingsException) {
            throw new AMRuntimeException.InvalidConfiguration((Throwable)settingsException);
        }
    }

    private Optional<String[]> _getNullableImageVariants(Settings settings) {
        PortletPreferencesSettings portletPreferencesSettings = (PortletPreferencesSettings)settings;
        PortletPreferences portletPreferences = portletPreferencesSettings.getPortletPreferences();
        Map map = portletPreferences.getMap();
        return Optional.ofNullable(map.get("imageVariants"));
    }

    private final boolean _isPositiveNumber(String s) {
        Matcher matcher = _positiveNumberPattern.matcher(s);
        return matcher.matches();
    }

    private void _normalizeProperties(Map<String, String> properties) {
        String maxHeightString = properties.get("max-height");
        String maxWidthString = properties.get("max-width");
        if (Validator.isNotNull((String)maxHeightString) && Validator.isNotNull((String)maxWidthString)) {
            return;
        }
        if (Validator.isNull((String)maxHeightString)) {
            properties.put("max-height", "0");
        }
        if (Validator.isNull((String)maxWidthString)) {
            properties.put("max-width", "0");
        }
    }

    private void _triggerConfigurationEvent(Object payload) {
        Message message = new Message();
        message.setPayload(payload);
        this._messageBus.sendMessage("liferay/adaptive_media_image_configuration", message);
    }

    private void _updateConfiguration(long companyId, List<AMImageConfigurationEntry> amImageConfigurationEntries) throws IOException {
        try {
            Settings settings = SettingsFactoryUtil.getSettings((SettingsLocator)new CompanyServiceSettingsLocator(companyId, AMImageCompanyConfiguration.class.getName()));
            ModifiableSettings modifiableSettings = settings.getModifiableSettings();
            Stream amImageConfigurationEntryStream = amImageConfigurationEntries.stream();
            List<String> imageVariants = amImageConfigurationEntryStream.map(this._amImageConfigurationEntryParser::getConfigurationString).collect(Collectors.toList());
            modifiableSettings.setValues("imageVariants", imageVariants.toArray(new String[0]));
            modifiableSettings.store();
            amImageConfigurationEntryStream = amImageConfigurationEntries.stream();
            this._portalCache.put((Serializable)Long.valueOf(companyId), (Object)amImageConfigurationEntryStream.collect(Collectors.toCollection(ArrayList::new)));
        }
        catch (SettingsException | ValidatorException exception) {
            throw new AMRuntimeException.InvalidConfiguration(exception);
        }
    }
}

