/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.adaptive.media.image.internal.media.query;

import com.liferay.adaptive.media.AdaptiveMedia;
import com.liferay.adaptive.media.image.configuration.AMImageConfigurationEntry;
import com.liferay.adaptive.media.image.configuration.AMImageConfigurationHelper;
import com.liferay.adaptive.media.image.finder.AMImageFinder;
import com.liferay.adaptive.media.image.internal.configuration.AMImageAttributeMapping;
import com.liferay.adaptive.media.image.internal.processor.AMImage;
import com.liferay.adaptive.media.image.media.query.Condition;
import com.liferay.adaptive.media.image.media.query.MediaQuery;
import com.liferay.adaptive.media.image.media.query.MediaQueryProvider;
import com.liferay.adaptive.media.image.processor.AMImageAttribute;
import com.liferay.adaptive.media.image.processor.AMImageProcessor;
import com.liferay.adaptive.media.image.url.AMImageURLFactory;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.util.HashMapBuilder;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={MediaQueryProvider.class})
public class MediaQueryProviderImpl
implements MediaQueryProvider {
    private static final Log _log = LogFactoryUtil.getLog(MediaQueryProviderImpl.class);
    @Reference
    private AMImageConfigurationHelper _amImageConfigurationHelper;
    @Reference
    private AMImageFinder _amImageFinder;
    @Reference
    private AMImageURLFactory _amImageURLFactory;
    private final Comparator<AdaptiveMedia<AMImageProcessor>> _comparator = Comparator.comparingInt(this::_getWidth);

    public List<MediaQuery> getMediaQueries(FileEntry fileEntry) throws PortalException {
        Collection<AdaptiveMedia<AMImageProcessor>> adaptiveMedias = this._getAdaptiveMedias(fileEntry);
        ArrayList<MediaQuery> mediaQueries = new ArrayList<MediaQuery>();
        AdaptiveMedia<AMImageProcessor> previousAdaptiveMedia = null;
        for (AdaptiveMedia<AMImageProcessor> adaptiveMedia : adaptiveMedias) {
            Optional<AdaptiveMedia<AMImageProcessor>> hdAdaptiveMediaOptional = this._getHDAdaptiveMedia(adaptiveMedia, adaptiveMedias);
            mediaQueries.add(this._getMediaQuery(adaptiveMedia, previousAdaptiveMedia, hdAdaptiveMediaOptional));
            previousAdaptiveMedia = adaptiveMedia;
        }
        return mediaQueries;
    }

    private Optional<AdaptiveMedia<AMImageProcessor>> _findAdaptiveMedia(FileEntry fileEntry, AMImageConfigurationEntry amImageConfigurationEntry) {
        try {
            Stream adaptiveMediaStream = this._amImageFinder.getAdaptiveMediaStream(amImageQueryBuilder -> amImageQueryBuilder.forFileEntry(fileEntry).forConfiguration(amImageConfigurationEntry.getUUID()).done());
            return adaptiveMediaStream.findFirst();
        }
        catch (PortalException portalException) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)portalException, (Throwable)portalException);
            }
            return Optional.empty();
        }
    }

    private AdaptiveMedia<AMImageProcessor> _getAdaptiveMediaFromConfigurationEntry(FileEntry fileEntry, AMImageConfigurationEntry amImageConfigurationEntry) {
        Optional<AdaptiveMedia<AMImageProcessor>> adaptiveMediaOptional = this._findAdaptiveMedia(fileEntry, amImageConfigurationEntry);
        if (adaptiveMediaOptional.isPresent()) {
            return adaptiveMediaOptional.get();
        }
        HashMap properties = HashMapBuilder.put((Object)AMImageAttribute.AM_IMAGE_ATTRIBUTE_WIDTH.getName(), () -> {
            Optional<Integer> widthOptional = this._getWidth(amImageConfigurationEntry);
            return String.valueOf(widthOptional.orElse(0));
        }).put((Object)AMImageAttribute.AM_IMAGE_ATTRIBUTE_HEIGHT.getName(), () -> {
            Optional<Integer> heightOptional = this._getHeight(amImageConfigurationEntry);
            return String.valueOf(heightOptional.orElse(0));
        }).build();
        return new AMImage(() -> null, AMImageAttributeMapping.fromProperties(properties), this._getFileEntryURL(fileEntry, amImageConfigurationEntry));
    }

    private Collection<AdaptiveMedia<AMImageProcessor>> _getAdaptiveMedias(FileEntry fileEntry) throws PortalException {
        Collection amImageConfigurationEntries = this._amImageConfigurationHelper.getAMImageConfigurationEntries(fileEntry.getCompanyId());
        ArrayList<AdaptiveMedia<AMImageProcessor>> adaptiveMedias = new ArrayList<AdaptiveMedia<AMImageProcessor>>();
        for (AMImageConfigurationEntry amImageConfigurationEntry : amImageConfigurationEntries) {
            AdaptiveMedia<AMImageProcessor> adaptiveMedia = this._getAdaptiveMediaFromConfigurationEntry(fileEntry, amImageConfigurationEntry);
            if (this._getWidth(adaptiveMedia) <= 0) continue;
            adaptiveMedias.add(adaptiveMedia);
        }
        Collections.sort(adaptiveMedias, this._comparator);
        return adaptiveMedias;
    }

    private List<Condition> _getConditions(AdaptiveMedia<AMImageProcessor> adaptiveMedia, AdaptiveMedia<AMImageProcessor> previousAdaptiveMedia) {
        ArrayList<Condition> conditions = new ArrayList<Condition>();
        conditions.add(new Condition("max-width", this._getWidth(adaptiveMedia) + "px"));
        if (previousAdaptiveMedia != null) {
            conditions.add(new Condition("min-width", this._getWidth(previousAdaptiveMedia) + "px"));
        }
        return conditions;
    }

    private URI _getFileEntryURL(FileEntry fileEntry, AMImageConfigurationEntry amImageConfigurationEntry) {
        try {
            return this._amImageURLFactory.createFileEntryURL(fileEntry.getFileVersion(), amImageConfigurationEntry);
        }
        catch (PortalException portalException) {
            throw new RuntimeException(portalException);
        }
    }

    private Optional<AdaptiveMedia<AMImageProcessor>> _getHDAdaptiveMedia(AdaptiveMedia<AMImageProcessor> originalAdaptiveMedia, Collection<AdaptiveMedia<AMImageProcessor>> adaptiveMedias) {
        for (AdaptiveMedia<AMImageProcessor> adaptiveMedia : adaptiveMedias) {
            int originalWidth = this._getWidth(originalAdaptiveMedia) * 2;
            int originalHeight = this._getHeight(originalAdaptiveMedia) * 2;
            IntStream widthIntStream = IntStream.range(originalWidth - 1, originalWidth + 2);
            boolean widthMatch = widthIntStream.anyMatch(value -> value == this._getWidth(adaptiveMedia));
            IntStream heightIntStream = IntStream.range(originalHeight - 1, originalHeight + 2);
            boolean heightMatch = heightIntStream.anyMatch(value -> value == this._getHeight(adaptiveMedia));
            if (!widthMatch || !heightMatch) continue;
            return Optional.of(adaptiveMedia);
        }
        return Optional.empty();
    }

    private Integer _getHeight(AdaptiveMedia<AMImageProcessor> adaptiveMedia) {
        Optional optional = adaptiveMedia.getValueOptional(AMImageAttribute.AM_IMAGE_ATTRIBUTE_HEIGHT);
        return optional.orElse(0);
    }

    private Optional<Integer> _getHeight(AMImageConfigurationEntry originalAMImageConfigurationEntry) {
        return this._getPropertiesValue(originalAMImageConfigurationEntry, "max-height");
    }

    private MediaQuery _getMediaQuery(AdaptiveMedia<AMImageProcessor> adaptiveMedia, AdaptiveMedia<AMImageProcessor> previousAdaptiveMedia, Optional<AdaptiveMedia<AMImageProcessor>> hdAdaptiveMediaOptional) throws PortalException {
        StringBundler sb = new StringBundler(4);
        List<Condition> conditions = this._getConditions(adaptiveMedia, previousAdaptiveMedia);
        sb.append((Object)adaptiveMedia.getURI());
        hdAdaptiveMediaOptional.ifPresent(hdAdaptiveMedia -> {
            sb.append(", ");
            sb.append((Object)hdAdaptiveMedia.getURI());
            sb.append(" 2x");
        });
        return new MediaQuery(conditions, sb.toString());
    }

    private Optional<Integer> _getPropertiesValue(AMImageConfigurationEntry amImageConfigurationEntry, String name) {
        try {
            Map properties = amImageConfigurationEntry.getProperties();
            Integer height = Integer.valueOf((String)properties.get(name));
            return Optional.of(height);
        }
        catch (NumberFormatException numberFormatException) {
            return Optional.empty();
        }
    }

    private Integer _getWidth(AdaptiveMedia<AMImageProcessor> adaptiveMedia) {
        Optional attributeValue = adaptiveMedia.getValueOptional(AMImageAttribute.AM_IMAGE_ATTRIBUTE_WIDTH);
        return attributeValue.orElse(0);
    }

    private Optional<Integer> _getWidth(AMImageConfigurationEntry amImageConfigurationEntry) {
        return this._getPropertiesValue(amImageConfigurationEntry, "max-width");
    }
}

