/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.adaptive.media.image.internal.handler;

import com.liferay.adaptive.media.AMAttribute;
import com.liferay.adaptive.media.exception.AMRuntimeException;
import com.liferay.adaptive.media.image.configuration.AMImageConfigurationHelper;
import com.liferay.adaptive.media.image.internal.util.Tuple;
import com.liferay.document.library.kernel.service.DLAppService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileVersion;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={PathInterpreter.class})
public class PathInterpreter {
    private static final Pattern _pattern = Pattern.compile("/image/(\\d+)(?:/(\\d+))?/([^/]+)/(?:[^/]+)");
    @Reference
    private AMImageConfigurationHelper _amImageConfigurationHelper;
    @Reference
    private DLAppService _dlAppService;

    public Optional<Tuple<FileVersion, Map<String, String>>> interpretPath(String pathInfo) {
        try {
            if (pathInfo == null) {
                throw new IllegalArgumentException("Path information is null");
            }
            Matcher matcher = _pattern.matcher(pathInfo);
            if (!matcher.matches()) {
                return Optional.empty();
            }
            long fileEntryId = Long.valueOf(matcher.group(1));
            FileVersion fileVersion = this._getFileVersion(this._dlAppService.getFileEntry(fileEntryId), this._getFileVersionId(matcher));
            Optional amImageConfigurationEntryOptional = this._amImageConfigurationHelper.getAMImageConfigurationEntry(fileVersion.getCompanyId(), this._getConfigurationEntryUUID(matcher));
            return Optional.of(Tuple.of(fileVersion, amImageConfigurationEntryOptional.map(amImageConfigurationEntry -> {
                Map curProperties = amImageConfigurationEntry.getProperties();
                AMAttribute configurationUuidAMAttribute = AMAttribute.getConfigurationUuidAMAttribute();
                curProperties.put(configurationUuidAMAttribute.getName(), amImageConfigurationEntry.getUUID());
                return curProperties;
            }).orElse(new HashMap())));
        }
        catch (PortalException portalException) {
            throw new AMRuntimeException((Throwable)portalException);
        }
    }

    private String _getConfigurationEntryUUID(Matcher matcher) {
        return matcher.group(3);
    }

    private FileVersion _getFileVersion(FileEntry fileEntry, long fileVersionId) throws PortalException {
        if (fileVersionId == 0L) {
            return fileEntry.getFileVersion();
        }
        return this._dlAppService.getFileVersion(fileVersionId);
    }

    private long _getFileVersionId(Matcher matcher) {
        if (matcher.group(2) == null) {
            return 0L;
        }
        return Long.valueOf(matcher.group(2));
    }
}

