/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.adaptive.media.image.internal.scaler;

import com.liferay.adaptive.media.exception.AMRuntimeException;
import com.liferay.adaptive.media.image.configuration.AMImageConfigurationEntry;
import com.liferay.adaptive.media.image.internal.processor.util.TiffOrientationTransformer;
import com.liferay.adaptive.media.image.internal.scaler.AMImageScaledImageImpl;
import com.liferay.adaptive.media.image.internal.util.RenderedImageUtil;
import com.liferay.adaptive.media.image.scaler.AMImageScaledImage;
import com.liferay.adaptive.media.image.scaler.AMImageScaler;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.image.ImageToolUtil;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.util.GetterUtil;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true, property={"mime.type=*"}, service={AMImageScaler.class})
public class AMDefaultImageScaler
implements AMImageScaler {
    public AMImageScaledImage scaleImage(FileVersion fileVersion, AMImageConfigurationEntry amImageConfigurationEntry) {
        try {
            RenderedImage renderedImage = TiffOrientationTransformer.transform(() -> this._getInputStream(fileVersion));
            Map properties = amImageConfigurationEntry.getProperties();
            int maxHeight = GetterUtil.getInteger((String)((String)properties.get("max-height")));
            int maxWidth = GetterUtil.getInteger((String)((String)properties.get("max-width")));
            RenderedImage scaledRenderedImage = ImageToolUtil.scale((RenderedImage)renderedImage, (int)maxHeight, (int)maxWidth);
            return new AMImageScaledImageImpl(RenderedImageUtil.getRenderedImageContentStream(scaledRenderedImage, fileVersion.getMimeType()), scaledRenderedImage.getHeight(), scaledRenderedImage.getWidth());
        }
        catch (PortalException | IOException e) {
            StringBundler sb = new StringBundler(4);
            sb.append("Unable to scale file entry ");
            sb.append(fileVersion.getFileEntryId());
            sb.append(" to match adaptive media configuration ");
            sb.append(amImageConfigurationEntry.getUUID());
            throw new AMRuntimeException.IOException(sb.toString(), e);
        }
    }

    private InputStream _getInputStream(FileVersion fileVersion) {
        try {
            return fileVersion.getContentStream(false);
        }
        catch (PortalException pe) {
            throw new AMRuntimeException.IOException((Throwable)pe);
        }
    }
}

