/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.adaptive.media.image.internal.processor;

import com.liferay.adaptive.media.exception.AMRuntimeException;
import com.liferay.adaptive.media.image.configuration.AMImageConfigurationEntry;
import com.liferay.adaptive.media.image.configuration.AMImageConfigurationHelper;
import com.liferay.adaptive.media.image.model.AMImageEntry;
import com.liferay.adaptive.media.image.processor.AMImageProcessor;
import com.liferay.adaptive.media.image.scaler.AMImageScaledImage;
import com.liferay.adaptive.media.image.scaler.AMImageScaler;
import com.liferay.adaptive.media.image.scaler.AMImageScalerTracker;
import com.liferay.adaptive.media.image.service.AMImageEntryLocalService;
import com.liferay.adaptive.media.image.validator.AMImageValidator;
import com.liferay.adaptive.media.processor.AMProcessor;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileVersion;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Optional;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"model.class.name=com.liferay.portal.kernel.repository.model.FileVersion"}, service={AMImageProcessor.class, AMProcessor.class})
public final class AMImageProcessorImpl
implements AMImageProcessor {
    @Reference
    private AMImageConfigurationHelper _amImageConfigurationHelper;
    @Reference
    private AMImageEntryLocalService _amImageEntryLocalService;
    @Reference
    private AMImageScalerTracker _amImageScalerTracker;
    @Reference
    private AMImageValidator _amImageValidator;

    public void cleanUp(FileVersion fileVersion) {
        try {
            if (!this._amImageValidator.isValid(fileVersion)) {
                return;
            }
            this._amImageEntryLocalService.deleteAMImageEntryFileVersion(fileVersion);
        }
        catch (PortalException pe) {
            throw new AMRuntimeException.IOException((Throwable)pe);
        }
    }

    public void process(FileVersion fileVersion) {
        if (!this._amImageValidator.isValid(fileVersion)) {
            return;
        }
        Collection amImageConfigurationEntries = this._amImageConfigurationHelper.getAMImageConfigurationEntries(fileVersion.getCompanyId());
        amImageConfigurationEntries.forEach(amImageConfigurationEntry -> this.process(fileVersion, amImageConfigurationEntry.getUUID()));
    }

    public void process(FileVersion fileVersion, String configurationEntryUuid) {
        if (!this._amImageValidator.isValid(fileVersion)) {
            return;
        }
        Optional amImageConfigurationEntryOptional = this._amImageConfigurationHelper.getAMImageConfigurationEntry(fileVersion.getCompanyId(), configurationEntryUuid);
        if (!amImageConfigurationEntryOptional.isPresent()) {
            return;
        }
        AMImageConfigurationEntry amImageConfigurationEntry = (AMImageConfigurationEntry)amImageConfigurationEntryOptional.get();
        AMImageEntry amImageEntry = this._amImageEntryLocalService.fetchAMImageEntry(amImageConfigurationEntry.getUUID(), fileVersion.getFileVersionId());
        try {
            AMImageScaler amImageScaler;
            FileEntry fileEntry = fileVersion.getFileEntry();
            if (amImageEntry != null && !fileEntry.isCheckedOut()) {
                return;
            }
            if (amImageEntry != null && fileEntry.isCheckedOut()) {
                this._amImageEntryLocalService.deleteAMImageEntry(amImageEntry.getAmImageEntryId());
            }
            if ((amImageScaler = this._amImageScalerTracker.getAMImageScaler(fileVersion.getMimeType())) == null) {
                return;
            }
            AMImageScaledImage amImageScaledImage = amImageScaler.scaleImage(fileVersion, amImageConfigurationEntry);
            try (InputStream inputStream = amImageScaledImage.getInputStream();){
                this._amImageEntryLocalService.addAMImageEntry(amImageConfigurationEntry, fileVersion, amImageScaledImage.getHeight(), amImageScaledImage.getWidth(), inputStream, amImageScaledImage.getSize());
            }
        }
        catch (PortalException | IOException e) {
            throw new AMRuntimeException.IOException(e);
        }
    }
}

