/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.adaptive.media.image.internal.finder;

import com.liferay.adaptive.media.AMAttribute;
import com.liferay.adaptive.media.AMDistanceComparator;
import com.liferay.adaptive.media.AdaptiveMedia;
import com.liferay.adaptive.media.finder.AMQuery;
import com.liferay.adaptive.media.image.configuration.AMImageConfigurationEntry;
import com.liferay.adaptive.media.image.finder.AMImageQueryBuilder;
import com.liferay.adaptive.media.image.internal.util.comparator.AMAttributeDistanceComparator;
import com.liferay.adaptive.media.image.internal.util.comparator.AMPropertyDistanceComparator;
import com.liferay.adaptive.media.image.processor.AMImageProcessor;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.util.Validator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;

public class AMImageQueryBuilderImpl
implements AMImageQueryBuilder,
AMImageQueryBuilder.ConfigurationStep,
AMImageQueryBuilder.FuzzySortStep,
AMImageQueryBuilder.InitialStep,
AMImageQueryBuilder.StrictSortStep {
    public static final AMQuery<FileVersion, AMImageProcessor> AM_QUERY = new AMQuery<FileVersion, AMImageProcessor>(){};
    private final Map<AMAttribute<AMImageProcessor, ?>, Object> _amAttributes = new LinkedHashMap();
    private AMImageQueryBuilder.ConfigurationStatus _configurationStatus;
    private String _configurationUuid;
    private FileEntry _fileEntry;
    private FileVersion _fileVersion;
    private final Map<AMAttribute<AMImageProcessor, ?>, AMImageQueryBuilder.SortOrder> _sortCriteria = new LinkedHashMap();

    public AMQuery<FileVersion, AMImageProcessor> done() {
        return AM_QUERY;
    }

    public AMImageQueryBuilder.FinalStep forConfiguration(String configurationUuid) {
        if (Validator.isNull((String)configurationUuid)) {
            throw new IllegalArgumentException("Configuration UUID is null");
        }
        this._configurationUuid = configurationUuid;
        return this;
    }

    public AMImageQueryBuilder.InitialStep forFileEntry(FileEntry fileEntry) {
        if (fileEntry == null) {
            throw new IllegalArgumentException("File entry is null");
        }
        this._fileEntry = fileEntry;
        return this;
    }

    public AMImageQueryBuilder.InitialStep forFileVersion(FileVersion fileVersion) {
        if (fileVersion == null) {
            throw new IllegalArgumentException("File version is null");
        }
        this._fileVersion = fileVersion;
        return this;
    }

    public Map<AMAttribute<AMImageProcessor, ?>, Object> getAMAttributes() {
        return this._amAttributes;
    }

    public AMDistanceComparator<AdaptiveMedia<AMImageProcessor>> getAMDistanceComparator() {
        if (!this._sortCriteria.isEmpty()) {
            return new AMAttributeDistanceComparator(this._sortCriteria);
        }
        if (!this._amAttributes.isEmpty()) {
            return new AMPropertyDistanceComparator(this._amAttributes);
        }
        return (v1, v2) -> 0L;
    }

    public Predicate<AMImageConfigurationEntry> getConfigurationEntryFilter() {
        if (this._hasConfiguration()) {
            return amImageConfigurationEntry -> this._configurationUuid.equals(amImageConfigurationEntry.getUUID());
        }
        return amImageConfigurationEntry -> true;
    }

    public AMImageQueryBuilder.ConfigurationStatus getConfigurationStatus() {
        if (this._configurationStatus != null) {
            return this._configurationStatus;
        }
        if (this._hasConfiguration()) {
            return AMImageQueryBuilder.ConfigurationStatus.ANY;
        }
        return AMImageQueryBuilder.ConfigurationStatus.ENABLED;
    }

    public String getConfigurationUuid() {
        return this._configurationUuid;
    }

    public FileVersion getFileVersion() throws PortalException {
        if (this._fileVersion != null) {
            return this._fileVersion;
        }
        this._fileVersion = this._fileEntry.getFileVersion();
        return this._fileVersion;
    }

    public boolean hasFileVersion() {
        return this._fileEntry == null;
    }

    public <V> AMImageQueryBuilder.StrictSortStep orderBy(AMAttribute<AMImageProcessor, V> amAttribute, AMImageQueryBuilder.SortOrder sortOrder) {
        if (amAttribute == null) {
            throw new IllegalArgumentException("Adaptive media attribute is null");
        }
        this._sortCriteria.put(amAttribute, sortOrder);
        return this;
    }

    public <V> AMImageQueryBuilder.FuzzySortStep with(AMAttribute<AMImageProcessor, V> amAttribute, Optional<V> valueOptional) {
        if (valueOptional == null) {
            throw new IllegalArgumentException("Adaptive media attribute value optional is null");
        }
        valueOptional.ifPresent(value -> this._amAttributes.put(amAttribute, value));
        return this;
    }

    public <V> AMImageQueryBuilder.FuzzySortStep with(AMAttribute<AMImageProcessor, V> amAttribute, V value) {
        if (value == null) {
            throw new IllegalArgumentException("Adaptive media attribute value is null");
        }
        this._amAttributes.put(amAttribute, value);
        return this;
    }

    public AMImageQueryBuilder.InitialStep withConfigurationStatus(AMImageQueryBuilder.ConfigurationStatus configurationStatus) {
        if (configurationStatus == null) {
            throw new IllegalArgumentException("Configuration status is null");
        }
        this._configurationStatus = configurationStatus;
        return this;
    }

    private boolean _hasConfiguration() {
        return Validator.isNotNull((String)this._configurationUuid);
    }
}

