/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.adaptive.media.image.internal.util;

import com.liferay.adaptive.media.exception.AMRuntimeException;
import com.liferay.portal.kernel.image.ImageToolUtil;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayOutputStream;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;

public class RenderedImageUtil {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] getRenderedImageContentStream(RenderedImage renderedImage, String mimeType) throws IOException {
        try (UnsyncByteArrayOutputStream baos = new UnsyncByteArrayOutputStream();){
            ImageToolUtil.write((RenderedImage)renderedImage, (String)mimeType, (OutputStream)baos);
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        catch (IOException ioe) {
            throw new AMRuntimeException.IOException((Throwable)ioe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RenderedImage readImage(InputStream inputStream) throws IOException {
        ImageInputStream imageInputStream = ImageIO.createImageInputStream(inputStream);
        Iterator<ImageReader> iterator = ImageIO.getImageReaders(imageInputStream);
        while (iterator.hasNext()) {
            ImageReader imageReader = null;
            try {
                imageReader = iterator.next();
                imageReader.setInput(imageInputStream);
                BufferedImage bufferedImage = imageReader.read(0);
                return bufferedImage;
            }
            catch (IOException ioe) {}
            continue;
            finally {
                if (imageReader == null) continue;
                imageReader.dispose();
            }
        }
        throw new IOException("Unsupported image type");
    }
}

