/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.adaptive.media.image.internal.configuration;

import com.liferay.adaptive.media.exception.AMImageConfigurationException;
import com.liferay.adaptive.media.exception.AMRuntimeException;
import com.liferay.adaptive.media.image.configuration.AMImageConfigurationEntry;
import com.liferay.adaptive.media.image.configuration.AMImageConfigurationHelper;
import com.liferay.adaptive.media.image.internal.configuration.AMImageCompanyConfiguration;
import com.liferay.adaptive.media.image.internal.configuration.AMImageConfigurationEntryImpl;
import com.liferay.adaptive.media.image.internal.configuration.AMImageConfigurationEntryParser;
import com.liferay.adaptive.media.image.service.AMImageEntryLocalService;
import com.liferay.portal.kernel.messaging.Destination;
import com.liferay.portal.kernel.messaging.DestinationConfiguration;
import com.liferay.portal.kernel.messaging.DestinationFactory;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageBus;
import com.liferay.portal.kernel.settings.CompanyServiceSettingsLocator;
import com.liferay.portal.kernel.settings.ModifiableSettings;
import com.liferay.portal.kernel.settings.PortletPreferencesSettings;
import com.liferay.portal.kernel.settings.Settings;
import com.liferay.portal.kernel.settings.SettingsException;
import com.liferay.portal.kernel.settings.SettingsFactoryUtil;
import com.liferay.portal.kernel.settings.SettingsLocator;
import com.liferay.portal.kernel.util.FriendlyURLNormalizerUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.portlet.PortletPreferences;
import javax.portlet.ValidatorException;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={AMImageConfigurationHelper.class})
public class AMImageConfigurationHelperImpl
implements AMImageConfigurationHelper {
    private static final Pattern _positiveNumberPattern = Pattern.compile("\\d*[1-9]\\d*");
    private AMImageConfigurationEntryParser _amImageConfigurationEntryParser;
    @Reference
    private AMImageEntryLocalService _amImageEntryLocalService;
    private final Map<Long, Collection<AMImageConfigurationEntry>> _configurationEntries = new ConcurrentHashMap<Long, Collection<AMImageConfigurationEntry>>();
    @Reference
    private DestinationFactory _destinationFactory;
    @Reference
    private MessageBus _messageBus;

    public AMImageConfigurationEntry addAMImageConfigurationEntry(long companyId, String name, String description, String uuid, Map<String, String> properties) throws AMImageConfigurationException, IOException {
        this._checkName(name);
        this._checkProperties(properties);
        this._normalizeProperties(properties);
        String normalizedUuid = FriendlyURLNormalizerUtil.normalize((String)uuid);
        this._checkUuid(normalizedUuid);
        Collection<AMImageConfigurationEntry> amImageConfigurationEntries = this.getAMImageConfigurationEntries(companyId, amImageConfigurationEntry -> true);
        this._checkDuplicatesName(amImageConfigurationEntries, name);
        this._checkDuplicatesUuid(amImageConfigurationEntries, normalizedUuid);
        ArrayList<AMImageConfigurationEntry> updatedAMImageConfigurationEntries = new ArrayList<AMImageConfigurationEntry>(amImageConfigurationEntries);
        updatedAMImageConfigurationEntries.removeIf(amImageConfigurationEntry -> normalizedUuid.equals(amImageConfigurationEntry.getUUID()));
        AMImageConfigurationEntryImpl amImageConfigurationEntry2 = new AMImageConfigurationEntryImpl(name, description, normalizedUuid, properties, true);
        updatedAMImageConfigurationEntries.add(amImageConfigurationEntry2);
        this._updateConfiguration(companyId, updatedAMImageConfigurationEntries);
        this._triggerConfigurationEvent(amImageConfigurationEntry2);
        return amImageConfigurationEntry2;
    }

    public void deleteAMImageConfigurationEntry(long companyId, String uuid) throws AMImageConfigurationException.InvalidStateAMImageConfigurationException, IOException {
        Optional<AMImageConfigurationEntry> amImageConfigurationEntryOptional = this.getAMImageConfigurationEntry(companyId, uuid);
        if (!amImageConfigurationEntryOptional.isPresent()) {
            return;
        }
        AMImageConfigurationEntry amImageConfigurationEntry = amImageConfigurationEntryOptional.get();
        if (amImageConfigurationEntry.isEnabled()) {
            throw new AMImageConfigurationException.InvalidStateAMImageConfigurationException();
        }
        this.forceDeleteAMImageConfigurationEntry(companyId, uuid);
    }

    public void disableAMImageConfigurationEntry(long companyId, String uuid) throws IOException {
        Optional<AMImageConfigurationEntry> amImageConfigurationEntryOptional = this.getAMImageConfigurationEntry(companyId, uuid);
        if (!amImageConfigurationEntryOptional.isPresent()) {
            return;
        }
        AMImageConfigurationEntry amImageConfigurationEntry = amImageConfigurationEntryOptional.get();
        if (!amImageConfigurationEntry.isEnabled()) {
            return;
        }
        Collection<AMImageConfigurationEntry> amImageConfigurationEntries = this.getAMImageConfigurationEntries(companyId, curConfigurationEntry -> true);
        ArrayList<AMImageConfigurationEntry> updatedAMImageConfigurationEntries = new ArrayList<AMImageConfigurationEntry>(amImageConfigurationEntries);
        updatedAMImageConfigurationEntries.removeIf(curConfigurationEntry -> uuid.equals(curConfigurationEntry.getUUID()));
        AMImageConfigurationEntryImpl newAMImageConfigurationEntry = new AMImageConfigurationEntryImpl(amImageConfigurationEntry.getName(), amImageConfigurationEntry.getDescription(), amImageConfigurationEntry.getUUID(), amImageConfigurationEntry.getProperties(), false);
        updatedAMImageConfigurationEntries.add(newAMImageConfigurationEntry);
        this._updateConfiguration(companyId, updatedAMImageConfigurationEntries);
        this._triggerConfigurationEvent(amImageConfigurationEntry);
    }

    public void enableAMImageConfigurationEntry(long companyId, String uuid) throws IOException {
        Optional<AMImageConfigurationEntry> amImageConfigurationEntryOptional = this.getAMImageConfigurationEntry(companyId, uuid);
        if (!amImageConfigurationEntryOptional.isPresent()) {
            return;
        }
        AMImageConfigurationEntry amImageConfigurationEntry = amImageConfigurationEntryOptional.get();
        if (amImageConfigurationEntry.isEnabled()) {
            return;
        }
        Collection<AMImageConfigurationEntry> amImageConfigurationEntries = this.getAMImageConfigurationEntries(companyId, curConfigurationEntry -> true);
        ArrayList<AMImageConfigurationEntry> updatedAMImageConfigurationEntries = new ArrayList<AMImageConfigurationEntry>(amImageConfigurationEntries);
        updatedAMImageConfigurationEntries.removeIf(curConfigurationEntry -> uuid.equals(curConfigurationEntry.getUUID()));
        AMImageConfigurationEntryImpl newAMImageConfigurationEntry = new AMImageConfigurationEntryImpl(amImageConfigurationEntry.getName(), amImageConfigurationEntry.getDescription(), amImageConfigurationEntry.getUUID(), amImageConfigurationEntry.getProperties(), true);
        updatedAMImageConfigurationEntries.add(newAMImageConfigurationEntry);
        this._updateConfiguration(companyId, updatedAMImageConfigurationEntries);
        this._triggerConfigurationEvent(amImageConfigurationEntry);
    }

    public void forceDeleteAMImageConfigurationEntry(long companyId, String uuid) throws IOException {
        Optional<AMImageConfigurationEntry> amImageConfigurationEntryOptional = this.getAMImageConfigurationEntry(companyId, uuid);
        if (!amImageConfigurationEntryOptional.isPresent()) {
            return;
        }
        AMImageConfigurationEntry amImageConfigurationEntry = amImageConfigurationEntryOptional.get();
        this._amImageEntryLocalService.deleteAMImageEntries(companyId, amImageConfigurationEntry);
        Collection<AMImageConfigurationEntry> amImageConfigurationEntries = this.getAMImageConfigurationEntries(companyId, curConfigurationEntry -> true);
        ArrayList<AMImageConfigurationEntry> updatedAMImageConfigurationEntries = new ArrayList<AMImageConfigurationEntry>(amImageConfigurationEntries);
        updatedAMImageConfigurationEntries.removeIf(curConfigurationEntry -> uuid.equals(curConfigurationEntry.getUUID()));
        this._updateConfiguration(companyId, updatedAMImageConfigurationEntries);
        this._triggerConfigurationEvent(amImageConfigurationEntry);
    }

    public Collection<AMImageConfigurationEntry> getAMImageConfigurationEntries(long companyId) {
        Stream<AMImageConfigurationEntry> amImageConfigurationEntryStream = this._getAMImageConfigurationEntries(companyId);
        return amImageConfigurationEntryStream.filter(AMImageConfigurationEntry::isEnabled).sorted(Comparator.comparing(AMImageConfigurationEntry::getName)).collect(Collectors.toList());
    }

    public Collection<AMImageConfigurationEntry> getAMImageConfigurationEntries(long companyId, Predicate<? super AMImageConfigurationEntry> predicate) {
        Stream<AMImageConfigurationEntry> amImageConfigurationEntryStream = this._getAMImageConfigurationEntries(companyId);
        return amImageConfigurationEntryStream.filter(predicate).sorted(Comparator.comparing(AMImageConfigurationEntry::getName)).collect(Collectors.toList());
    }

    public Optional<AMImageConfigurationEntry> getAMImageConfigurationEntry(long companyId, String configurationEntryUUID) {
        Stream<AMImageConfigurationEntry> amImageConfigurationEntryStream = this._getAMImageConfigurationEntries(companyId);
        return amImageConfigurationEntryStream.filter(amImageConfigurationEntry -> configurationEntryUUID.equals(amImageConfigurationEntry.getUUID())).findFirst();
    }

    public AMImageConfigurationEntry updateAMImageConfigurationEntry(long companyId, String oldUuid, String name, String description, String newUuid, Map<String, String> properties) throws AMImageConfigurationException, IOException {
        this._checkName(name);
        this._checkProperties(properties);
        this._normalizeProperties(properties);
        String normalizedUuid = FriendlyURLNormalizerUtil.normalize((String)newUuid);
        this._checkUuid(normalizedUuid);
        Collection<AMImageConfigurationEntry> amImageConfigurationEntries = this.getAMImageConfigurationEntries(companyId, amImageConfigurationEntry -> true);
        Stream<AMImageConfigurationEntry> amImageConfigurationEntryStream = amImageConfigurationEntries.stream();
        Optional<AMImageConfigurationEntry> oldAMImageConfigurationEntryOptional = amImageConfigurationEntryStream.filter(amImageConfigurationEntry -> oldUuid.equals(amImageConfigurationEntry.getUUID())).findFirst();
        AMImageConfigurationEntry oldAMImageConfigurationEntry = oldAMImageConfigurationEntryOptional.orElseThrow(() -> new AMImageConfigurationException.NoSuchAMImageConfigurationException("{uuid=" + oldUuid + "}"));
        if (!name.equals(oldAMImageConfigurationEntry.getName())) {
            this._checkDuplicatesName(amImageConfigurationEntries, name);
        }
        if (!oldUuid.equals(normalizedUuid)) {
            this._checkDuplicatesUuid(amImageConfigurationEntries, normalizedUuid);
        }
        ArrayList<AMImageConfigurationEntry> updatedAMImageConfigurationEntries = new ArrayList<AMImageConfigurationEntry>(amImageConfigurationEntries);
        updatedAMImageConfigurationEntries.removeIf(amImageConfigurationEntry -> oldUuid.equals(amImageConfigurationEntry.getUUID()));
        AMImageConfigurationEntryImpl amImageConfigurationEntry2 = new AMImageConfigurationEntryImpl(name, description, normalizedUuid, properties, oldAMImageConfigurationEntry.isEnabled());
        updatedAMImageConfigurationEntries.add(amImageConfigurationEntry2);
        this._updateConfiguration(companyId, updatedAMImageConfigurationEntries);
        this._triggerConfigurationEvent(new AMImageConfigurationEntry[]{oldAMImageConfigurationEntry, amImageConfigurationEntry2});
        return amImageConfigurationEntry2;
    }

    @Activate
    protected void activate() {
        DestinationConfiguration destinationConfiguration = new DestinationConfiguration("synchronous", "liferay/adaptive_media_image_configuration");
        Destination destination = this._destinationFactory.createDestination(destinationConfiguration);
        this._messageBus.addDestination(destination);
    }

    @Deactivate
    protected void deactivate() {
        this._messageBus.removeDestination("liferay/adaptive_media_image_configuration");
    }

    @Reference(unbind="-")
    protected void setAMImageConfigurationEntryParser(AMImageConfigurationEntryParser amImageConfigurationEntryParser) {
        this._amImageConfigurationEntryParser = amImageConfigurationEntryParser;
    }

    private static final boolean _isPositiveNumber(String s) {
        Matcher matcher = _positiveNumberPattern.matcher(s);
        return matcher.matches();
    }

    private void _checkDuplicatesName(Collection<AMImageConfigurationEntry> amImageConfigurationEntries, String name) throws AMImageConfigurationException {
        Stream<AMImageConfigurationEntry> amImageConfigurationEntryStream = amImageConfigurationEntries.stream();
        Optional<AMImageConfigurationEntry> duplicateNameAMImageConfigurationEntryOptional = amImageConfigurationEntryStream.filter(amImageConfigurationEntry -> name.equals(amImageConfigurationEntry.getName())).findFirst();
        if (duplicateNameAMImageConfigurationEntryOptional.isPresent()) {
            throw new AMImageConfigurationException.DuplicateAMImageConfigurationNameException();
        }
    }

    private void _checkDuplicatesUuid(Collection<AMImageConfigurationEntry> amImageConfigurationEntries, String uuid) throws AMImageConfigurationException {
        Stream<AMImageConfigurationEntry> amImageConfigurationEntryStream = amImageConfigurationEntries.stream();
        Optional<AMImageConfigurationEntry> duplicateUuidAMImageConfigurationEntryOptional = amImageConfigurationEntryStream.filter(amImageConfigurationEntry -> uuid.equals(amImageConfigurationEntry.getUUID())).findFirst();
        if (duplicateUuidAMImageConfigurationEntryOptional.isPresent()) {
            throw new AMImageConfigurationException.DuplicateAMImageConfigurationUuidException();
        }
    }

    private void _checkName(String name) throws AMImageConfigurationException {
        if (Validator.isNull((String)name)) {
            throw new AMImageConfigurationException.InvalidNameException();
        }
    }

    private void _checkProperties(Map<String, String> properties) throws AMImageConfigurationException {
        String maxHeightString = properties.get("max-height");
        if (Validator.isNotNull((String)maxHeightString) && !maxHeightString.equals("0") && !AMImageConfigurationHelperImpl._isPositiveNumber(maxHeightString)) {
            throw new AMImageConfigurationException.InvalidHeightException();
        }
        String maxWidthString = properties.get("max-width");
        if (Validator.isNotNull((String)maxWidthString) && !maxWidthString.equals("0") && !AMImageConfigurationHelperImpl._isPositiveNumber(maxWidthString)) {
            throw new AMImageConfigurationException.InvalidWidthException();
        }
        if ((Validator.isNull((String)maxHeightString) || maxHeightString.equals("0")) && (Validator.isNull((String)maxWidthString) || maxWidthString.equals("0"))) {
            throw new AMImageConfigurationException.RequiredWidthOrHeightException();
        }
    }

    private void _checkUuid(String uuid) throws AMImageConfigurationException {
        if (Validator.isNull((String)uuid)) {
            throw new AMImageConfigurationException.InvalidUuidException();
        }
    }

    private Stream<AMImageConfigurationEntry> _getAMImageConfigurationEntries(long companyId) {
        if (this._configurationEntries.containsKey(companyId)) {
            Collection<AMImageConfigurationEntry> amImageConfigurationEntries = this._configurationEntries.get(companyId);
            return amImageConfigurationEntries.stream();
        }
        try {
            Settings settings = SettingsFactoryUtil.getSettings((SettingsLocator)new CompanyServiceSettingsLocator(companyId, AMImageCompanyConfiguration.class.getName()));
            Optional<String[]> nullableImageVariants = this._getNullableImageVariants(settings);
            String[] imageVariants = nullableImageVariants.orElseGet(() -> settings.getValues("imageVariants", new String[0]));
            List amImageConfigurationEntries = Stream.of(imageVariants).map(this._amImageConfigurationEntryParser::parse).collect(Collectors.toList());
            this._configurationEntries.put(companyId, amImageConfigurationEntries);
            return amImageConfigurationEntries.stream();
        }
        catch (SettingsException se) {
            throw new AMRuntimeException.InvalidConfiguration((Throwable)se);
        }
    }

    private Optional<String[]> _getNullableImageVariants(Settings settings) {
        PortletPreferencesSettings portletPreferencesSettings = (PortletPreferencesSettings)settings;
        PortletPreferences portletPreferences = portletPreferencesSettings.getPortletPreferences();
        Map map = portletPreferences.getMap();
        return Optional.ofNullable(map.get("imageVariants"));
    }

    private void _normalizeProperties(Map<String, String> properties) {
        String maxHeightString = properties.get("max-height");
        String maxWidthString = properties.get("max-width");
        if (Validator.isNotNull((String)maxHeightString) && Validator.isNotNull((String)maxWidthString)) {
            return;
        }
        if (Validator.isNull((String)maxHeightString)) {
            properties.put("max-height", "0");
        }
        if (Validator.isNull((String)maxWidthString)) {
            properties.put("max-width", "0");
        }
    }

    private void _triggerConfigurationEvent(Object payload) {
        Message message = new Message();
        message.setPayload(payload);
        this._messageBus.sendMessage("liferay/adaptive_media_image_configuration", message);
    }

    private void _updateConfiguration(long companyId, List<AMImageConfigurationEntry> amImageConfigurationEntries) throws IOException {
        try {
            Settings settings = SettingsFactoryUtil.getSettings((SettingsLocator)new CompanyServiceSettingsLocator(companyId, AMImageCompanyConfiguration.class.getName()));
            ModifiableSettings modifiableSettings = settings.getModifiableSettings();
            Stream amImageConfigurationEntryStream = amImageConfigurationEntries.stream();
            List<String> imageVariants = amImageConfigurationEntryStream.map(this._amImageConfigurationEntryParser::getConfigurationString).collect(Collectors.toList());
            modifiableSettings.setValues("imageVariants", imageVariants.toArray(new String[imageVariants.size()]));
            modifiableSettings.store();
            amImageConfigurationEntryStream = amImageConfigurationEntries.stream();
            this._configurationEntries.put(companyId, amImageConfigurationEntryStream.collect(Collectors.toList()));
        }
        catch (SettingsException | ValidatorException e) {
            throw new AMRuntimeException.InvalidConfiguration(e);
        }
    }
}

