/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.adaptive.media.image.internal.url;

import com.liferay.adaptive.media.AMURIResolver;
import com.liferay.adaptive.media.exception.AMRuntimeException;
import com.liferay.adaptive.media.image.configuration.AMImageConfigurationEntry;
import com.liferay.adaptive.media.image.url.AMImageURLFactory;
import com.liferay.portal.kernel.repository.model.FileVersion;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={AMImageURLFactory.class})
public class AMImageURLFactoryImpl
implements AMImageURLFactory {
    private AMURIResolver _amURIResolver;

    public URI createFileEntryURL(FileVersion fileVersion, AMImageConfigurationEntry amImageConfigurationEntry) {
        String relativeURI = String.format("image/%d/%s/%s", fileVersion.getFileEntryId(), amImageConfigurationEntry.getUUID(), this._encode(fileVersion.getFileName()));
        return this._amURIResolver.resolveURI(URI.create(relativeURI));
    }

    public URI createFileVersionURL(FileVersion fileVersion, AMImageConfigurationEntry amImageConfigurationEntry) {
        String relativeURI = String.format("image/%d/%d/%s/%s", fileVersion.getFileEntryId(), fileVersion.getFileVersionId(), amImageConfigurationEntry.getUUID(), this._encode(fileVersion.getFileName()));
        return this._amURIResolver.resolveURI(URI.create(relativeURI));
    }

    @Reference(unbind="-")
    protected void setAMURIResolver(AMURIResolver amURIResolver) {
        this._amURIResolver = amURIResolver;
    }

    private String _encode(String s) {
        try {
            return URLEncoder.encode(s, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException uee) {
            throw new AMRuntimeException.UnsupportedEncodingException((Throwable)uee);
        }
    }
}

