/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.adaptive.media.image.internal.processor.util;

import com.drew.imaging.ImageMetadataReader;
import com.drew.metadata.Metadata;
import com.drew.metadata.exif.ExifIFD0Directory;
import com.liferay.adaptive.media.exception.AMRuntimeException;
import com.liferay.adaptive.media.image.internal.util.RenderedImageUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.image.ImageToolUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import java.util.function.Supplier;

public class TiffOrientationTransformer {
    private static final int _ORIENTATION_VALUE_HORIZONTAL_NORMAL = 1;
    private static final int _ORIENTATION_VALUE_MIRROR_HORIZONTAL = 2;
    private static final int _ORIENTATION_VALUE_MIRROR_HORIZONTAL_ROTATE_90_CW = 7;
    private static final int _ORIENTATION_VALUE_MIRROR_HORIZONTAL_ROTATE_270_CW = 5;
    private static final int _ORIENTATION_VALUE_MIRROR_VERTICAL = 4;
    private static final int _ORIENTATION_VALUE_ROTATE_90_CW = 6;
    private static final int _ORIENTATION_VALUE_ROTATE_180 = 3;
    private static final int _ORIENTATION_VALUE_ROTATE_270_CW = 8;
    private static final Log _log = LogFactoryUtil.getLog(TiffOrientationTransformer.class);

    public static RenderedImage transform(Supplier<InputStream> inputStreamSupplier) throws PortalException {
        try {
            Optional<Integer> tiffOrientationValueOptional = TiffOrientationTransformer._getTiffOrientationValue(inputStreamSupplier);
            if (tiffOrientationValueOptional.isPresent()) {
                return TiffOrientationTransformer._transform(inputStreamSupplier, tiffOrientationValueOptional.get());
            }
            return RenderedImageUtil.readImage(inputStreamSupplier.get());
        }
        catch (IOException ioe) {
            throw new AMRuntimeException.IOException((Throwable)ioe);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Optional<Integer> _getTiffOrientationValue(Supplier<InputStream> inputStreamSupplier) throws PortalException {
        try (InputStream inputStream = inputStreamSupplier.get();){
            Metadata metadata = ImageMetadataReader.readMetadata(inputStream);
            ExifIFD0Directory exifIFD0Directory = metadata.getFirstDirectoryOfType(ExifIFD0Directory.class);
            if (exifIFD0Directory == null || !exifIFD0Directory.containsTag(274)) {
                Optional<Integer> optional2 = Optional.empty();
                return optional2;
            }
            Optional<Integer> optional = Optional.of(exifIFD0Directory.getInt(274));
            return optional;
        }
        catch (Exception e) {
            if (!_log.isWarnEnabled()) return Optional.empty();
            _log.warn((Object)e, (Throwable)e);
            return Optional.empty();
        }
    }

    private static RenderedImage _transform(Supplier<InputStream> inputStreamSupplier, int tiffOrientationValue) throws IOException {
        RenderedImage renderedImage = RenderedImageUtil.readImage(inputStreamSupplier.get());
        if (tiffOrientationValue == 1) {
            return renderedImage;
        }
        if (tiffOrientationValue == 2) {
            return ImageToolUtil.flipHorizontal((RenderedImage)renderedImage);
        }
        if (tiffOrientationValue == 7) {
            return ImageToolUtil.flipVertical((RenderedImage)ImageToolUtil.rotate((RenderedImage)renderedImage, (int)90));
        }
        if (tiffOrientationValue == 5) {
            return ImageToolUtil.flipVertical((RenderedImage)ImageToolUtil.rotate((RenderedImage)renderedImage, (int)270));
        }
        if (tiffOrientationValue == 4) {
            return ImageToolUtil.flipVertical((RenderedImage)renderedImage);
        }
        if (tiffOrientationValue == 6) {
            return ImageToolUtil.rotate((RenderedImage)renderedImage, (int)90);
        }
        if (tiffOrientationValue == 3) {
            return ImageToolUtil.rotate((RenderedImage)renderedImage, (int)180);
        }
        if (tiffOrientationValue == 8) {
            return ImageToolUtil.rotate((RenderedImage)renderedImage, (int)270);
        }
        return renderedImage;
    }
}

