/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.adaptive.media.document.library.internal.repository.capabilities;

import com.liferay.adaptive.media.document.library.internal.util.AMCleanUpOnUpdateAndCheckInThreadLocal;
import com.liferay.adaptive.media.image.service.AMImageEntryLocalService;
import com.liferay.adaptive.media.processor.AMAsyncProcessor;
import com.liferay.adaptive.media.processor.AMAsyncProcessorLocator;
import com.liferay.document.library.security.io.InputStreamSanitizer;
import com.liferay.exportimport.kernel.lar.ExportImportThreadLocal;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.repository.capabilities.Capability;
import com.liferay.portal.kernel.repository.event.RepositoryEventAware;
import com.liferay.portal.kernel.repository.event.RepositoryEventType;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileEntryWrapper;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.repository.model.FileVersionWrapper;
import com.liferay.portal.kernel.repository.registry.RepositoryEventRegistry;
import java.io.InputStream;
import java.util.List;
import org.osgi.service.component.annotations.Reference;

public abstract class BaseCapability
implements Capability,
RepositoryEventAware {
    @Reference
    protected AMAsyncProcessorLocator amAsyncProcessorLocator;
    @Reference
    protected AMImageEntryLocalService amImageEntryLocalService;
    @Reference
    protected InputStreamSanitizer inputStreamSanitizer;

    public void registerRepositoryEventListeners(RepositoryEventRegistry repositoryEventRegistry) {
        repositoryEventRegistry.registerRepositoryEventListener(RepositoryEventType.Add.class, FileEntry.class, this::_updateAdaptiveMedia);
        repositoryEventRegistry.registerRepositoryEventListener(RepositoryEventType.Delete.class, FileEntry.class, this::_deleteAdaptiveMedia);
        repositoryEventRegistry.registerRepositoryEventListener(RepositoryEventType.Update.class, FileEntry.class, this::_updateAdaptiveMedia);
    }

    private void _deleteAdaptiveMedia(FileEntry fileEntry) {
        if (ExportImportThreadLocal.isImportInProcess()) {
            return;
        }
        try {
            AMAsyncProcessor amAsyncProcessor = this.amAsyncProcessorLocator.locateForClass(FileVersion.class);
            List fileVersions = fileEntry.getFileVersions(-1);
            for (FileVersion fileVersion : fileVersions) {
                amAsyncProcessor.triggerCleanUp((Object)fileVersion, String.valueOf(fileVersion.getFileVersionId()));
            }
        }
        catch (PortalException pe) {
            throw new RuntimeException(pe);
        }
    }

    private void _updateAdaptiveMedia(FileEntry fileEntry) {
        if (ExportImportThreadLocal.isImportInProcess()) {
            return;
        }
        try {
            FileVersion latestFileVersion = fileEntry.getLatestFileVersion(true);
            if (AMCleanUpOnUpdateAndCheckInThreadLocal.isEnabled()) {
                this.amImageEntryLocalService.deleteAMImageEntryFileVersion(latestFileVersion);
            }
            AMAsyncProcessor amAsyncProcessor = this.amAsyncProcessorLocator.locateForClass(FileVersion.class);
            amAsyncProcessor.triggerProcess((Object)this._wrap(latestFileVersion), String.valueOf(latestFileVersion.getFileVersionId()));
        }
        catch (PortalException pe) {
            throw new RuntimeException(pe);
        }
    }

    private FileVersion _wrap(FileVersion fileVersion) {
        if (fileVersion == null) {
            return null;
        }
        return new SafeFileVersion(fileVersion);
    }

    private class SafeFileVersion
    extends FileVersionWrapper {
        public SafeFileVersion(FileVersion fileVersion) {
            super(fileVersion);
        }

        public InputStream getContentStream(boolean incrementCounter) throws PortalException {
            return BaseCapability.this.inputStreamSanitizer.sanitize(super.getContentStream(incrementCounter));
        }

        public FileEntry getFileEntry() throws PortalException {
            return new SafeFileEntry(super.getFileEntry());
        }
    }

    private class SafeFileEntry
    extends FileEntryWrapper {
        public SafeFileEntry(FileEntry fileEntry) {
            super(fileEntry);
        }

        public InputStream getContentStream() throws PortalException {
            return BaseCapability.this.inputStreamSanitizer.sanitize(super.getContentStream());
        }

        public InputStream getContentStream(String version) throws PortalException {
            return BaseCapability.this.inputStreamSanitizer.sanitize(super.getContentStream(version));
        }

        public FileVersion getFileVersion() throws PortalException {
            return new SafeFileVersion(super.getFileVersion());
        }

        public FileVersion getFileVersion(String version) throws PortalException {
            return new SafeFileVersion(super.getFileVersion(version));
        }

        public FileVersion getLatestFileVersion() throws PortalException {
            return new SafeFileVersion(super.getLatestFileVersion());
        }

        public FileVersion getLatestFileVersion(boolean trusted) throws PortalException {
            return new SafeFileVersion(super.getLatestFileVersion(trusted));
        }
    }
}

