/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.adaptive.media.document.library.web.internal.optimizer;

import com.liferay.adaptive.media.image.configuration.AMImageConfigurationEntry;
import com.liferay.adaptive.media.image.configuration.AMImageConfigurationHelper;
import com.liferay.adaptive.media.image.counter.AMImageCounter;
import com.liferay.adaptive.media.image.mime.type.AMImageMimeTypeProvider;
import com.liferay.adaptive.media.image.optimizer.AMImageOptimizer;
import com.liferay.adaptive.media.image.processor.AMImageProcessor;
import com.liferay.document.library.kernel.service.DLFileEntryLocalService;
import com.liferay.document.library.kernel.service.DLFileVersionLocalService;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskStatusMessageSender;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskThreadLocal;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.Projection;
import com.liferay.portal.kernel.dao.orm.ProjectionFactoryUtil;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.repository.liferayrepository.model.LiferayFileEntry;
import com.liferay.trash.kernel.service.TrashEntryLocalService;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicInteger;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"adaptive.media.key=document-library"}, service={AMImageOptimizer.class})
public class DLAMImageOptimizer
implements AMImageOptimizer {
    private static final Log _log = LogFactoryUtil.getLog(DLAMImageOptimizer.class);
    @Reference
    private AMImageConfigurationHelper _amImageConfigurationHelper;
    @Reference(target="(adaptive.media.key=document-library)")
    private AMImageCounter _amImageCounter;
    @Reference
    private AMImageMimeTypeProvider _amImageMimeTypeProvider;
    @Reference
    private AMImageProcessor _amImageProcessor;
    @Reference
    private BackgroundTaskStatusMessageSender _backgroundTaskStatusMessageSender;
    @Reference
    private ClassNameLocalService _classNameLocalService;
    @Reference
    private DLFileEntryLocalService _dlFileEntryLocalService;
    @Reference
    private DLFileVersionLocalService _dlFileVersionLocalService;
    @Reference
    private TrashEntryLocalService _trashEntryLocalService;

    public void optimize(long companyId) {
        Collection amImageConfigurationEntries = this._amImageConfigurationHelper.getAMImageConfigurationEntries(companyId);
        int count = this._amImageCounter.countExpectedAMImageEntries(companyId);
        int total = count * amImageConfigurationEntries.size();
        AtomicInteger successCount = new AtomicInteger(0);
        AtomicInteger errorCount = new AtomicInteger(0);
        for (AMImageConfigurationEntry amImageConfigurationEntry : amImageConfigurationEntries) {
            this._optimize(companyId, amImageConfigurationEntry.getUUID(), total, successCount, errorCount);
        }
    }

    public void optimize(long companyId, String configurationEntryUuid) {
        int total = this._amImageCounter.countExpectedAMImageEntries(companyId);
        AtomicInteger successCount = new AtomicInteger(0);
        AtomicInteger errorCount = new AtomicInteger(0);
        this._optimize(companyId, configurationEntryUuid, total, successCount, errorCount);
    }

    private void _optimize(long companyId, String configurationEntryUuid, int total, AtomicInteger successCount, AtomicInteger errorCount) {
        ActionableDynamicQuery actionableDynamicQuery = this._dlFileEntryLocalService.getActionableDynamicQuery();
        actionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> {
            Property companyIdProperty = PropertyFactoryUtil.forName((String)"companyId");
            dynamicQuery.add(companyIdProperty.eq((Object)companyId));
            Property groupIdProperty = PropertyFactoryUtil.forName((String)"groupId");
            Property repositoryIdProperty = PropertyFactoryUtil.forName((String)"repositoryId");
            dynamicQuery.add(groupIdProperty.eqProperty(repositoryIdProperty));
            Property mimeTypeProperty = PropertyFactoryUtil.forName((String)"mimeType");
            dynamicQuery.add(mimeTypeProperty.in((Object[])this._amImageMimeTypeProvider.getSupportedMimeTypes()));
            DynamicQuery dlFileVersionDynamicQuery = this._dlFileVersionLocalService.dynamicQuery();
            dlFileVersionDynamicQuery.setProjection(ProjectionFactoryUtil.distinct((Projection)ProjectionFactoryUtil.property((String)"fileEntryId")));
            dlFileVersionDynamicQuery.add(companyIdProperty.eq((Object)companyId));
            dlFileVersionDynamicQuery.add(groupIdProperty.eqProperty(repositoryIdProperty));
            dlFileVersionDynamicQuery.add(mimeTypeProperty.in((Object[])this._amImageMimeTypeProvider.getSupportedMimeTypes()));
            Property statusProperty = PropertyFactoryUtil.forName((String)"status");
            dlFileVersionDynamicQuery.add(statusProperty.eq((Object)8));
            Property fileEntryIdProperty = PropertyFactoryUtil.forName((String)"fileEntryId");
            dynamicQuery.add(fileEntryIdProperty.notIn(dlFileVersionDynamicQuery));
        });
        actionableDynamicQuery.setPerformActionMethod(dlFileEntry -> {
            LiferayFileEntry fileEntry = new LiferayFileEntry(dlFileEntry);
            try {
                this._amImageProcessor.process(fileEntry.getFileVersion(), configurationEntryUuid);
                this._sendStatusMessage(successCount.incrementAndGet(), total, errorCount.get());
            }
            catch (Exception exception) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)("Unable to process file entry " + fileEntry.getFileEntryId()), (Throwable)exception);
                }
                this._sendStatusMessage(successCount.get(), total, errorCount.incrementAndGet());
            }
        });
        try {
            actionableDynamicQuery.performActions();
        }
        catch (PortalException portalException) {
            _log.error((Object)portalException, (Throwable)portalException);
        }
    }

    private void _sendStatusMessage(int count, int total, int errors) {
        Message message = new Message();
        message.put("backgroundTaskId", (Object)BackgroundTaskThreadLocal.getBackgroundTaskId());
        Class<?> clazz = this.getClass();
        message.put("className", (Object)clazz.getName());
        message.put("count", (Object)count);
        message.put("errors", (Object)errors);
        message.put("total", (Object)total);
        message.put("status", (Object)1);
        this._backgroundTaskStatusMessageSender.sendBackgroundTaskStatusMessage(message);
    }
}

