/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.adaptive.media.document.library.web.internal.counter;

import com.liferay.adaptive.media.image.counter.AMImageCounter;
import com.liferay.adaptive.media.image.mime.type.AMImageMimeTypeProvider;
import com.liferay.document.library.kernel.service.DLFileEntryLocalService;
import com.liferay.document.library.kernel.service.DLFileVersionLocalService;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.ProjectionFactoryUtil;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"adaptive.media.key=document-library"}, service={AMImageCounter.class})
public class DLAMImageCounter
implements AMImageCounter {
    @Reference
    private AMImageMimeTypeProvider _amImageMimeTypeProvider;
    @Reference
    private DLFileEntryLocalService _dlFileEntryLocalService;
    @Reference
    private DLFileVersionLocalService _dlFileVersionLocalService;

    public int countExpectedAMImageEntries(long companyId) {
        return this._getFileEntriesCount(companyId) - this._getTrashedFileEntriesCount(companyId);
    }

    private int _getFileEntriesCount(long companyId) {
        DynamicQuery dlFileEntryEntryDynamicQuery = this._dlFileEntryLocalService.dynamicQuery();
        Property companyIdProperty = PropertyFactoryUtil.forName((String)"companyId");
        dlFileEntryEntryDynamicQuery.add(companyIdProperty.eq((Object)companyId));
        Property groupIdProperty = PropertyFactoryUtil.forName((String)"groupId");
        Property repositoryIdProperty = PropertyFactoryUtil.forName((String)"repositoryId");
        dlFileEntryEntryDynamicQuery.add(groupIdProperty.eqProperty(repositoryIdProperty));
        Property mimeTypeProperty = PropertyFactoryUtil.forName((String)"mimeType");
        dlFileEntryEntryDynamicQuery.add(mimeTypeProperty.in((Object[])this._amImageMimeTypeProvider.getSupportedMimeTypes()));
        return (int)this._dlFileEntryLocalService.dynamicQueryCount(dlFileEntryEntryDynamicQuery);
    }

    private int _getTrashedFileEntriesCount(long companyId) {
        DynamicQuery dlFileVersionDynamicQuery = this._dlFileVersionLocalService.dynamicQuery();
        dlFileVersionDynamicQuery.setProjection(ProjectionFactoryUtil.countDistinct((String)"fileEntryId"));
        Property companyIdProperty = PropertyFactoryUtil.forName((String)"companyId");
        dlFileVersionDynamicQuery.add(companyIdProperty.eq((Object)companyId));
        Property groupIdProperty = PropertyFactoryUtil.forName((String)"groupId");
        Property repositoryIdProperty = PropertyFactoryUtil.forName((String)"repositoryId");
        dlFileVersionDynamicQuery.add(groupIdProperty.eqProperty(repositoryIdProperty));
        Property mimeTypeProperty = PropertyFactoryUtil.forName((String)"mimeType");
        dlFileVersionDynamicQuery.add(mimeTypeProperty.in((Object[])this._amImageMimeTypeProvider.getSupportedMimeTypes()));
        Property statusProperty = PropertyFactoryUtil.forName((String)"status");
        dlFileVersionDynamicQuery.add(statusProperty.eq((Object)8));
        return (int)this._dlFileEntryLocalService.dynamicQueryCount(dlFileVersionDynamicQuery);
    }
}

