/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.adaptive.media.document.library.thumbnails.internal.osgi.commands;

import com.liferay.adaptive.media.image.configuration.AMImageConfigurationEntry;
import com.liferay.portal.kernel.util.GetterUtil;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;

public class ThumbnailConfiguration {
    private final int _height;
    private final Pattern _pattern;
    private final int _width;

    public ThumbnailConfiguration(int width, int height, Pattern pattern) {
        this._width = width;
        this._height = height;
        this._pattern = pattern;
    }

    public long getFileVersionId(String fileName) {
        Matcher matcher = this._pattern.matcher(fileName);
        if (!matcher.matches()) {
            return 0L;
        }
        return GetterUtil.getLong((String)matcher.group(1));
    }

    public boolean matches(AMImageConfigurationEntry amImageConfigurationEntry) {
        Map properties = amImageConfigurationEntry.getProperties();
        int maxWidth = GetterUtil.getInteger((String)((String)properties.get("max-width")));
        int maxHeight = GetterUtil.getInteger((String)((String)properties.get("max-height")));
        return this._width != 0 && this._height != 0 && this._width == maxWidth && this._height == maxHeight;
    }

    public Optional<AMImageConfigurationEntry> selectMatchingConfigurationEntry(Collection<AMImageConfigurationEntry> amImageConfigurationEntries) {
        Stream<AMImageConfigurationEntry> amImageConfigurationEntryStream = amImageConfigurationEntries.stream();
        return amImageConfigurationEntryStream.filter(this::matches).findFirst();
    }
}

