/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.adaptive.media.document.library.thumbnails.internal.util;

import com.liferay.adaptive.media.exception.AMImageConfigurationException;
import com.liferay.adaptive.media.image.configuration.AMImageConfigurationEntry;
import com.liferay.adaptive.media.image.configuration.AMImageConfigurationHelper;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.util.PrefsPropsUtil;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={AMCompanyThumbnailConfigurationInitializer.class})
public class AMCompanyThumbnailConfigurationInitializer {
    private static final Pattern _pattern = Pattern.compile("[^\\w-]");
    @Reference
    private AMImageConfigurationHelper _amImageConfigurationHelper;

    public void initializeCompany(Company company) throws AMImageConfigurationException, IOException {
        int dlFileEntryPreviewMaxHeight = PrefsPropsUtil.getInteger((String)"dl.file.entry.preview.document.max.height");
        int dlFileEntryPreviewMaxWidth = PrefsPropsUtil.getInteger((String)"dl.file.entry.preview.document.max.width");
        if (dlFileEntryPreviewMaxHeight > 0 || dlFileEntryPreviewMaxWidth > 0) {
            this._createAMDocumentLibraryPreviewConfiguration(company, dlFileEntryPreviewMaxHeight, dlFileEntryPreviewMaxWidth);
        }
        int dlFileEntryThumbnailMaxHeight = PrefsPropsUtil.getInteger((String)"dl.file.entry.thumbnail.max.height");
        int dlFileEntryThumbnailMaxWidth = PrefsPropsUtil.getInteger((String)"dl.file.entry.thumbnail.max.width");
        if (dlFileEntryThumbnailMaxHeight > 0 && dlFileEntryThumbnailMaxWidth > 0) {
            this._createAMDocumentLibraryThumbnailConfiguration(company, dlFileEntryThumbnailMaxHeight, dlFileEntryThumbnailMaxWidth);
        }
        int dlFileEntryThumbnailCustom1MaxHeight = PrefsPropsUtil.getInteger((String)"dl.file.entry.thumbnail.custom1.max.height");
        int dlFileEntryThumbnailCustom1MaxWidth = PrefsPropsUtil.getInteger((String)"dl.file.entry.thumbnail.custom1.max.width");
        if (dlFileEntryThumbnailCustom1MaxHeight > 0 && dlFileEntryThumbnailCustom1MaxWidth > 0) {
            this._createAMDocumentLibraryThumbnailConfiguration(company, dlFileEntryThumbnailCustom1MaxHeight, dlFileEntryThumbnailCustom1MaxWidth);
        }
        int dlFileEntryThumbnailCustom2MaxHeight = PrefsPropsUtil.getInteger((String)"dl.file.entry.thumbnail.custom2.max.height");
        int dlFileEntryThumbnailCustom2MaxWidth = PrefsPropsUtil.getInteger((String)"dl.file.entry.thumbnail.custom2.max.width");
        if (dlFileEntryThumbnailCustom2MaxHeight > 0 && dlFileEntryThumbnailCustom2MaxWidth > 0) {
            this._createAMDocumentLibraryThumbnailConfiguration(company, dlFileEntryThumbnailCustom2MaxHeight, dlFileEntryThumbnailCustom2MaxWidth);
        }
    }

    private void _createAMDocumentLibraryConfiguration(Company company, String name, int maxHeight, int maxWidth) throws AMImageConfigurationException, IOException {
        String uuid = this._normalize(name);
        if (!this._hasConfiguration(company.getCompanyId(), name, uuid)) {
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("max-height", String.valueOf(maxHeight));
            properties.put("max-width", String.valueOf(maxWidth));
            this._amImageConfigurationHelper.addAMImageConfigurationEntry(company.getCompanyId(), name, "This image resolution was automatically added.", uuid, properties);
        }
    }

    private void _createAMDocumentLibraryPreviewConfiguration(Company company, int maxHeight, int maxWidth) throws AMImageConfigurationException, IOException {
        String name = String.format("%s %dx%d", "Preview", maxWidth, maxHeight);
        this._createAMDocumentLibraryConfiguration(company, name, maxHeight, maxWidth);
    }

    private void _createAMDocumentLibraryThumbnailConfiguration(Company company, int maxHeight, int maxWidth) throws AMImageConfigurationException, IOException {
        String name = String.format("%s %dx%d", "Thumbnail", maxWidth, maxHeight);
        this._createAMDocumentLibraryConfiguration(company, name, maxHeight, maxWidth);
    }

    private boolean _hasConfiguration(long companyId, String name, String uuid) {
        Collection amImageConfigurationEntries = this._amImageConfigurationHelper.getAMImageConfigurationEntries(companyId);
        Stream amImageConfigurationEntryStream = amImageConfigurationEntries.stream();
        Optional<AMImageConfigurationEntry> duplicateNameAMImageConfigurationEntryOptional = amImageConfigurationEntryStream.filter(amImageConfigurationEntry -> name.equals(amImageConfigurationEntry.getName()) || uuid.equals(amImageConfigurationEntry.getUUID())).findFirst();
        return duplicateNameAMImageConfigurationEntryOptional.isPresent();
    }

    private String _normalize(String str) {
        Matcher matcher = _pattern.matcher(str);
        return matcher.replaceAll("-");
    }
}

