Liferay.Loader.define("account-admin-web@1.0.21/account_users_admin/js/AccountUserEmailDomainValidator.es", ['module', 'exports', 'require', 'frontend-js-web', 'frontend-js-metal-web$metal-state'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = void 0;

  var _frontendJsWeb = require("frontend-js-web");

  var _metalState = require("frontend-js-metal-web$metal-state");

  function _typeof(obj) {
    "@babel/helpers - typeof";
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties(Constructor.prototype, protoProps);if (staticProps) _defineProperties(Constructor, staticProps);return Constructor;
  }

  function _possibleConstructorReturn(self, call) {
    if (call && (_typeof(call) === "object" || typeof call === "function")) {
      return call;
    }return _assertThisInitialized(self);
  }

  function _assertThisInitialized(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }return self;
  }

  function _getPrototypeOf(o) {
    _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };return _getPrototypeOf(o);
  }

  function _inherits(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });if (superClass) _setPrototypeOf(subClass, superClass);
  }

  function _setPrototypeOf(o, p) {
    _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;return o;
    };return _setPrototypeOf(o, p);
  }

  var AccountUserEmailDomainValidator =
  /*#__PURE__*/
  function (_PortletBase) {
    _inherits(AccountUserEmailDomainValidator, _PortletBase);

    function AccountUserEmailDomainValidator() {
      _classCallCheck(this, AccountUserEmailDomainValidator);

      return _possibleConstructorReturn(this, _getPrototypeOf(AccountUserEmailDomainValidator).apply(this, arguments));
    }

    _createClass(AccountUserEmailDomainValidator, [{
      key: "attached",
      value: function attached() {
        var _this = this;

        Liferay.once(this.ns('formReady'), function (event) {
          var form = Liferay.Form.get(event.formName);
          var field = form.formValidator.getField(_this.ns('emailAddress'));

          if (field) {
            _this.addFieldMessage_(field);

            var emailDomainFieldRule = _this.getEmailDomainFieldRule_();

            _this.addFormFieldRules_(form, [emailDomainFieldRule]);

            _this.setWarningValidationStyle_(form, field, emailDomainFieldRule.validatorName);
          }
        }, this);
      }
    }, {
      key: "addFieldMessage_",
      value: function addFieldMessage_(field) {
        var _this2 = this;

        var container = document.createElement('div');
        container.className = 'form-text';
        var button = document.createElement('button');
        button.className = 'btn btn-link btn-unstyled link-secondary';
        button.innerText = Liferay.Language.get('view-valid-domains');

        button.onclick = function () {
          _this2.openDialog_(_this2.viewValidDomainsURL);
        };

        button.type = 'button';
        container.appendChild(button);
        field.placeAfter(container);
      }
    }, {
      key: "addFormFieldRules_",
      value: function addFormFieldRules_(form, fieldRules) {
        var oldFieldRules = form.get('fieldRules');
        form.set('fieldRules', oldFieldRules.concat(fieldRules));
      }
    }, {
      key: "getEmailDomainFieldRule_",
      value: function getEmailDomainFieldRule_() {
        var accountEntryNames = this.accountEntryNames;
        var validDomains = this.validDomains.split(',');
        var validatorName = 'emailDomain';
        return {
          body: function body(val, field) {
            var emailDomain = val.substr(val.indexOf('@') + 1);

            if (!validDomains.includes(emailDomain)) {
              var fieldName = field.get('name');
              var errorMessages = this.get('fieldStrings');

              if (!errorMessages[fieldName]) {
                errorMessages[fieldName] = {};
              }

              errorMessages[fieldName][validatorName] = Liferay.Util.sub(Liferay.Language.get('x-is-not-a-valid-domain-for-the-following-accounts-x'), emailDomain, accountEntryNames);
              return false;
            }

            return true;
          },
          custom: true,
          fieldName: this.ns('emailAddress'),
          validatorName: validatorName
        };
      }
    }, {
      key: "onSubmitError_",
      value: function onSubmitError_(event, form, field, validatorName) {
        event.preventDefault();
        var errors = event.validator.errors;
        var fieldErrors = errors[field.get('name')];

        if (fieldErrors.length == 1 && fieldErrors[0] == validatorName) {
          submitForm(form);
          event.halt();
        }
      }
    }, {
      key: "openDialog_",
      value: function openDialog_(url) {
        Liferay.Util.openWindow({
          dialog: {
            height: 400,
            modal: true,
            width: 600
          },
          title: Liferay.Language.get('valid-domains'),
          uri: url
        });
      }
    }, {
      key: "setWarningValidationStyle_",
      value: function setWarningValidationStyle_(form, formField, validatorName) {
        var _this3 = this;

        var formValidator = form.formValidator;
        formValidator.after('errorField', function (event) {
          if (event.validator.field == formField && event.validator.errors[0] == validatorName) {
            var fieldContainer = formValidator.findFieldContainer(formField);

            if (fieldContainer) {
              fieldContainer.replaceClass('has-error', 'has-warning');
            }
          }
        });
        var resetFieldCss = formValidator.resetFieldCss;

        formValidator.resetFieldCss = function (field) {
          resetFieldCss.apply(formValidator, [field]);

          if (field != formField) {
            return;
          }

          var fieldContainer = formValidator.findFieldContainer(field);

          if (fieldContainer) {
            fieldContainer.removeClass('has-warning');
          }
        };

        formValidator.on('submitError', function (event) {
          _this3.onSubmitError_(event, form, formField, validatorName);
        }, this);
      }
    }]);

    return AccountUserEmailDomainValidator;
  }(_frontendJsWeb.PortletBase);

  AccountUserEmailDomainValidator.STATE = {
    accountEntryNames: _metalState.Config.string,
    validDomains: _metalState.Config.string,
    viewValidDomainsURL: _metalState.Config.string
  };
  var _default = AccountUserEmailDomainValidator;
  exports["default"] = _default;
  //# sourceMappingURL=AccountUserEmailDomainValidator.es.js.map
});
//# sourceMappingURL=AccountUserEmailDomainValidator.es.js.map