/*
 * Decompiled with CFR 0.152.
 */
package com.leinardi.android.speeddial;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Shader;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.os.Build;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.view.animation.Interpolator;
import androidx.annotation.Nullable;
import androidx.core.view.ViewCompat;
import androidx.interpolator.view.animation.FastOutSlowInInterpolator;
import com.leinardi.android.speeddial.R;

public class UiUtils {
    private UiUtils() {
    }

    public static int getPrimaryColor(Context context) {
        int colorAttr = Build.VERSION.SDK_INT >= 21 ? 16843827 : context.getResources().getIdentifier("colorPrimary", "attr", context.getPackageName());
        TypedValue outValue = new TypedValue();
        context.getTheme().resolveAttribute(colorAttr, outValue, true);
        return outValue.data;
    }

    public static int getOnSecondaryColor(Context context) {
        int colorAttr = Build.VERSION.SDK_INT >= 21 ? R.attr.colorOnSecondary : context.getResources().getIdentifier("colorOnSecondary", "attr", context.getPackageName());
        TypedValue outValue = new TypedValue();
        context.getTheme().resolveAttribute(colorAttr, outValue, true);
        return outValue.data;
    }

    public static int getAccentColor(Context context) {
        int colorAttr = Build.VERSION.SDK_INT >= 21 ? 16843829 : context.getResources().getIdentifier("colorAccent", "attr", context.getPackageName());
        TypedValue outValue = new TypedValue();
        context.getTheme().resolveAttribute(colorAttr, outValue, true);
        return outValue.data;
    }

    public static int dpToPx(Context context, float dp) {
        DisplayMetrics metrics = context.getResources().getDisplayMetrics();
        return Math.round(TypedValue.applyDimension((int)1, (float)dp, (DisplayMetrics)metrics));
    }

    public static int pxToDp(float px) {
        return Math.round(px / Resources.getSystem().getDisplayMetrics().density);
    }

    public static void fadeOutAnim(final View view) {
        ViewCompat.animate((View)view).cancel();
        view.setAlpha(1.0f);
        view.setVisibility(0);
        ViewCompat.animate((View)view).alpha(0.0f).withLayer().setDuration((long)view.getContext().getResources().getInteger(R.integer.sd_close_animation_duration)).setInterpolator((Interpolator)new FastOutSlowInInterpolator()).withEndAction(new Runnable(){

            @Override
            public void run() {
                view.setVisibility(8);
            }
        }).start();
    }

    public static void fadeInAnim(View view) {
        ViewCompat.animate((View)view).cancel();
        view.setAlpha(0.0f);
        view.setVisibility(0);
        ViewCompat.animate((View)view).alpha(1.0f).withLayer().setDuration((long)view.getContext().getResources().getInteger(R.integer.sd_open_animation_duration)).setInterpolator((Interpolator)new FastOutSlowInInterpolator()).start();
    }

    public static void enlargeAnim(View view, long startOffset) {
        ViewCompat.animate((View)view).cancel();
        view.setVisibility(0);
        Animation anim2 = AnimationUtils.loadAnimation((Context)view.getContext(), (int)R.anim.sd_scale_fade_and_translate_in);
        anim2.setStartOffset(startOffset);
        view.startAnimation(anim2);
    }

    public static void shrinkAnim(final View view, long startOffset) {
        ViewCompat.animate((View)view).cancel();
        view.setVisibility(0);
        Animation anim2 = AnimationUtils.loadAnimation((Context)view.getContext(), (int)R.anim.sd_scale_fade_and_translate_out);
        anim2.setStartOffset(startOffset);
        anim2.setAnimationListener(new Animation.AnimationListener(){

            public void onAnimationEnd(Animation animation) {
                view.setVisibility(8);
            }

            public void onAnimationStart(Animation animation) {
            }

            public void onAnimationRepeat(Animation animation) {
            }
        });
        view.startAnimation(anim2);
    }

    public static void shrinkAnim(final View view, final boolean removeView) {
        ViewCompat.animate((View)view).cancel();
        ViewCompat.animate((View)view).alpha(0.0f).withLayer().setDuration((long)view.getContext().getResources().getInteger(R.integer.sd_close_animation_duration)).setInterpolator((Interpolator)new FastOutSlowInInterpolator()).withEndAction(new Runnable(){

            @Override
            public void run() {
                if (removeView) {
                    ViewGroup parent = (ViewGroup)view.getParent();
                    if (parent != null) {
                        parent.removeView(view);
                    }
                } else {
                    view.setVisibility(8);
                }
            }
        }).start();
    }

    public static void rotateForward(View view, float angle, boolean animate) {
        ViewCompat.animate((View)view).rotation(angle).withLayer().setDuration(animate ? (long)view.getContext().getResources().getInteger(R.integer.sd_rotate_animation_duration) : 0L).setInterpolator((Interpolator)new FastOutSlowInInterpolator()).start();
    }

    public static void rotateBackward(View view, boolean animate) {
        ViewCompat.animate((View)view).rotation(0.0f).withLayer().setDuration(animate ? (long)view.getContext().getResources().getInteger(R.integer.sd_rotate_animation_duration) : 0L).setInterpolator((Interpolator)new FastOutSlowInInterpolator()).start();
    }

    public static Drawable getRotateDrawable(final Drawable drawable, final float angle) {
        if (angle == 0.0f) {
            return drawable;
        }
        Drawable[] drawables = new Drawable[]{drawable};
        return new LayerDrawable(drawables){

            public void draw(Canvas canvas) {
                canvas.save();
                canvas.rotate(angle, (float)drawable.getIntrinsicWidth() / 2.0f, (float)drawable.getIntrinsicHeight() / 2.0f);
                super.draw(canvas);
                canvas.restore();
            }
        };
    }

    @Nullable
    public static Bitmap getBitmapFromDrawable(@Nullable Drawable drawable) {
        BitmapDrawable bitmapDrawable;
        if (drawable == null) {
            return null;
        }
        if (drawable instanceof BitmapDrawable && (bitmapDrawable = (BitmapDrawable)drawable).getBitmap() != null) {
            return bitmapDrawable.getBitmap();
        }
        Bitmap bitmap = drawable.getIntrinsicWidth() <= 0 || drawable.getIntrinsicHeight() <= 0 ? Bitmap.createBitmap((int)1, (int)1, (Bitmap.Config)Bitmap.Config.ARGB_8888) : Bitmap.createBitmap((int)drawable.getIntrinsicWidth(), (int)drawable.getIntrinsicHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        drawable.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
        drawable.draw(canvas);
        return bitmap;
    }

    @Nullable
    public static Drawable getDrawableFromBitmap(@Nullable Bitmap bitmap) {
        if (bitmap == null) {
            return null;
        }
        return new BitmapDrawable(bitmap);
    }

    public static void performTap(final View view) {
        view.setPressed(true);
        view.postDelayed(new Runnable(){

            @Override
            public void run() {
                view.setPressed(false);
                view.performClick();
            }
        }, (long)ViewConfiguration.getTapTimeout());
    }

    public static Drawable cropFabImageInCircle(Drawable fabIcon) {
        int height;
        Bitmap bitmap = UiUtils.getBitmapFromDrawable(fabIcon);
        if (bitmap == null) {
            Log.e((String)"ContentValues", (String)"Couldn't crop the Image");
            return fabIcon;
        }
        int width = bitmap.getWidth();
        if (width > (height = bitmap.getHeight())) {
            bitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)(width / 2 - height / 2), (int)0, (int)height, (int)height);
        } else if (width < height) {
            bitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)(height / 2 - width / 2), (int)width, (int)width);
        }
        Bitmap circleBitmap = Bitmap.createBitmap((int)bitmap.getWidth(), (int)bitmap.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        BitmapShader shader = new BitmapShader(bitmap, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP);
        Paint paint = new Paint();
        paint.setAntiAlias(true);
        paint.setShader((Shader)shader);
        int circleCenter = bitmap.getWidth() / 2;
        Canvas canvas = new Canvas(circleBitmap);
        canvas.drawCircle((float)circleCenter, (float)circleCenter, (float)circleCenter, paint);
        Drawable cropped = UiUtils.getDrawableFromBitmap(circleBitmap);
        if (cropped == null) {
            Log.e((String)"ContentValues", (String)"Couldn't crop the Image");
            return fabIcon;
        }
        return cropped;
    }
}

