/*
 * Decompiled with CFR 0.152.
 */
package com.leinardi.android.speeddial;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.Parcel;
import android.os.Parcelable;
import android.view.ContextThemeWrapper;
import androidx.annotation.ColorInt;
import androidx.annotation.DrawableRes;
import androidx.annotation.IdRes;
import androidx.annotation.Nullable;
import androidx.annotation.StringRes;
import androidx.annotation.StyleRes;
import androidx.appcompat.content.res.AppCompatResources;
import com.leinardi.android.speeddial.FabWithLabelView;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class SpeedDialActionItem
implements Parcelable {
    public static final int RESOURCE_NOT_SET = Integer.MIN_VALUE;
    public static final String TYPE_NORMAL = "normal";
    public static final String TYPE_FILL = "fill";
    @IdRes
    private final int mId;
    @Nullable
    private final String mLabel;
    @StringRes
    private final int mLabelRes;
    @Nullable
    private final String mContentDescription;
    @StringRes
    private final int mContentDescriptionRes;
    @DrawableRes
    private final int mFabImageResource;
    @Nullable
    private final Drawable mFabImageDrawable;
    @ColorInt
    private final int mFabImageTintColor;
    private final boolean mFabImageTint;
    private final String mFabType;
    @ColorInt
    private final int mFabBackgroundColor;
    @ColorInt
    private final int mLabelColor;
    @ColorInt
    private final int mLabelBackgroundColor;
    private final boolean mLabelClickable;
    private final int mFabSize;
    @StyleRes
    private final int mTheme;
    public static final Parcelable.Creator<SpeedDialActionItem> CREATOR = new Parcelable.Creator<SpeedDialActionItem>(){

        public SpeedDialActionItem createFromParcel(Parcel source) {
            return new SpeedDialActionItem(source);
        }

        public SpeedDialActionItem[] newArray(int size) {
            return new SpeedDialActionItem[size];
        }
    };

    private SpeedDialActionItem(Builder builder) {
        this.mId = builder.mId;
        this.mLabel = builder.mLabel;
        this.mLabelRes = builder.mLabelRes;
        this.mContentDescription = builder.mContentDescription;
        this.mContentDescriptionRes = builder.mContentDescriptionRes;
        this.mFabImageTintColor = builder.mFabImageTintColor;
        this.mFabImageTint = builder.mFabImageTint;
        this.mFabType = builder.mFabType;
        this.mFabImageResource = builder.mFabImageResource;
        this.mFabImageDrawable = builder.mFabImageDrawable;
        this.mFabBackgroundColor = builder.mFabBackgroundColor;
        this.mLabelColor = builder.mLabelColor;
        this.mLabelBackgroundColor = builder.mLabelBackgroundColor;
        this.mLabelClickable = builder.mLabelClickable;
        this.mFabSize = builder.mFabSize;
        this.mTheme = builder.mTheme;
    }

    public int getId() {
        return this.mId;
    }

    @Nullable
    public String getLabel(Context context) {
        if (this.mLabel != null) {
            return this.mLabel;
        }
        if (this.mLabelRes != Integer.MIN_VALUE) {
            return context.getString(this.mLabelRes);
        }
        return null;
    }

    @Nullable
    public String getContentDescription(Context context) {
        if (this.mContentDescription != null) {
            return this.mContentDescription;
        }
        if (this.mContentDescriptionRes != Integer.MIN_VALUE) {
            return context.getString(this.mContentDescriptionRes);
        }
        return null;
    }

    @Nullable
    public Drawable getFabImageDrawable(Context context) {
        if (this.mFabImageDrawable != null) {
            return this.mFabImageDrawable;
        }
        if (this.mFabImageResource != Integer.MIN_VALUE) {
            return AppCompatResources.getDrawable((Context)context, (int)this.mFabImageResource);
        }
        return null;
    }

    @ColorInt
    public int getFabImageTintColor() {
        return this.mFabImageTintColor;
    }

    public boolean getFabImageTint() {
        return this.mFabImageTint;
    }

    @FabType
    public String getFabType() {
        return this.mFabType;
    }

    @ColorInt
    public int getFabBackgroundColor() {
        return this.mFabBackgroundColor;
    }

    @ColorInt
    public int getLabelColor() {
        return this.mLabelColor;
    }

    public int getLabelBackgroundColor() {
        return this.mLabelBackgroundColor;
    }

    public boolean isLabelClickable() {
        return this.mLabelClickable;
    }

    @StyleRes
    public int getTheme() {
        return this.mTheme;
    }

    public FabWithLabelView createFabWithLabelView(Context context) {
        int theme = this.getTheme();
        FabWithLabelView fabWithLabelView = theme == Integer.MIN_VALUE ? new FabWithLabelView(context) : new FabWithLabelView((Context)new ContextThemeWrapper(context, theme), null, theme);
        fabWithLabelView.setSpeedDialActionItem(this);
        return fabWithLabelView;
    }

    public int getFabSize() {
        return this.mFabSize;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mId);
        dest.writeString(this.mLabel);
        dest.writeInt(this.mLabelRes);
        dest.writeString(this.mContentDescription);
        dest.writeInt(this.mContentDescriptionRes);
        dest.writeInt(this.mFabImageResource);
        dest.writeInt(this.mFabImageTintColor);
        dest.writeByte(this.mFabImageTint ? (byte)1 : 0);
        dest.writeString(this.mFabType);
        dest.writeInt(this.mFabBackgroundColor);
        dest.writeInt(this.mLabelColor);
        dest.writeInt(this.mLabelBackgroundColor);
        dest.writeByte(this.mLabelClickable ? (byte)1 : 0);
        dest.writeInt(this.mFabSize);
        dest.writeInt(this.mTheme);
    }

    protected SpeedDialActionItem(Parcel in) {
        this.mId = in.readInt();
        this.mLabel = in.readString();
        this.mLabelRes = in.readInt();
        this.mContentDescription = in.readString();
        this.mContentDescriptionRes = in.readInt();
        this.mFabImageResource = in.readInt();
        this.mFabImageDrawable = null;
        this.mFabImageTintColor = in.readInt();
        this.mFabImageTint = in.readByte() != 0;
        this.mFabType = in.readString();
        this.mFabBackgroundColor = in.readInt();
        this.mLabelColor = in.readInt();
        this.mLabelBackgroundColor = in.readInt();
        this.mLabelClickable = in.readByte() != 0;
        this.mFabSize = in.readInt();
        this.mTheme = in.readInt();
    }

    public static class Builder {
        @IdRes
        private final int mId;
        @DrawableRes
        private final int mFabImageResource;
        @Nullable
        private Drawable mFabImageDrawable;
        @ColorInt
        private int mFabImageTintColor = Integer.MIN_VALUE;
        private boolean mFabImageTint = true;
        private String mFabType = "normal";
        @Nullable
        private String mLabel;
        @StringRes
        private int mLabelRes = Integer.MIN_VALUE;
        @Nullable
        private String mContentDescription;
        @StringRes
        private int mContentDescriptionRes = Integer.MIN_VALUE;
        @ColorInt
        private int mFabBackgroundColor = Integer.MIN_VALUE;
        @ColorInt
        private int mLabelColor = Integer.MIN_VALUE;
        @ColorInt
        private int mLabelBackgroundColor = Integer.MIN_VALUE;
        private boolean mLabelClickable = true;
        private int mFabSize = -1;
        @StyleRes
        private int mTheme = Integer.MIN_VALUE;

        public Builder(@IdRes int id2, @DrawableRes int fabImageResource) {
            this.mId = id2;
            this.mFabImageResource = fabImageResource;
            this.mFabImageDrawable = null;
        }

        public Builder(@IdRes int id2, @Nullable Drawable drawable) {
            this.mId = id2;
            this.mFabImageDrawable = drawable;
            this.mFabImageResource = Integer.MIN_VALUE;
        }

        public Builder(SpeedDialActionItem speedDialActionItem) {
            this.mId = speedDialActionItem.mId;
            this.mLabel = speedDialActionItem.mLabel;
            this.mLabelRes = speedDialActionItem.mLabelRes;
            this.mContentDescription = speedDialActionItem.mContentDescription;
            this.mContentDescriptionRes = speedDialActionItem.mContentDescriptionRes;
            this.mFabImageResource = speedDialActionItem.mFabImageResource;
            this.mFabImageDrawable = speedDialActionItem.mFabImageDrawable;
            this.mFabImageTintColor = speedDialActionItem.mFabImageTintColor;
            this.mFabImageTint = speedDialActionItem.mFabImageTint;
            this.mFabType = speedDialActionItem.mFabType;
            this.mFabBackgroundColor = speedDialActionItem.mFabBackgroundColor;
            this.mLabelColor = speedDialActionItem.mLabelColor;
            this.mLabelBackgroundColor = speedDialActionItem.mLabelBackgroundColor;
            this.mLabelClickable = speedDialActionItem.mLabelClickable;
            this.mFabSize = speedDialActionItem.mFabSize;
            this.mTheme = speedDialActionItem.mTheme;
        }

        public Builder setLabel(@Nullable String label) {
            this.mLabel = label;
            if (this.mContentDescription == null || this.mContentDescriptionRes == Integer.MIN_VALUE) {
                this.mContentDescription = label;
            }
            return this;
        }

        public Builder setLabel(@StringRes int labelRes) {
            this.mLabelRes = labelRes;
            if (this.mContentDescription == null || this.mContentDescriptionRes == Integer.MIN_VALUE) {
                this.mContentDescriptionRes = labelRes;
            }
            return this;
        }

        public Builder setContentDescription(@Nullable String contentDescription) {
            this.mContentDescription = contentDescription;
            return this;
        }

        public Builder setContentDescription(@StringRes int contentDescriptionRes) {
            this.mContentDescriptionRes = contentDescriptionRes;
            return this;
        }

        public Builder setFabImageTintColor(@Nullable @ColorInt Integer fabImageTintColor) {
            if (fabImageTintColor == null) {
                this.mFabImageTint = false;
            } else {
                this.mFabImageTint = true;
                this.mFabImageTintColor = fabImageTintColor;
            }
            return this;
        }

        public Builder setFabType(@FabType String fabType) {
            this.mFabType = fabType;
            return this;
        }

        public Builder setFabBackgroundColor(@ColorInt int fabBackgroundColor) {
            this.mFabBackgroundColor = fabBackgroundColor;
            return this;
        }

        public Builder setLabelColor(@ColorInt int labelColor) {
            this.mLabelColor = labelColor;
            return this;
        }

        public Builder setLabelBackgroundColor(@ColorInt int labelBackgroundColor) {
            this.mLabelBackgroundColor = labelBackgroundColor;
            return this;
        }

        public Builder setLabelClickable(boolean labelClickable) {
            this.mLabelClickable = labelClickable;
            return this;
        }

        public Builder setTheme(int mTheme) {
            this.mTheme = mTheme;
            return this;
        }

        public SpeedDialActionItem create() {
            return new SpeedDialActionItem(this);
        }

        public Builder setFabSize(int fabSize) {
            this.mFabSize = fabSize;
            return this;
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface FabType {
    }
}

