/*
 * Decompiled with CFR 0.152.
 */
package com.leinardi.android.speeddial;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.ColorInt;
import androidx.annotation.Nullable;
import androidx.cardview.widget.CardView;
import androidx.core.content.res.ResourcesCompat;
import androidx.core.widget.ImageViewCompat;
import com.google.android.material.floatingactionbutton.FloatingActionButton;
import com.leinardi.android.speeddial.R;
import com.leinardi.android.speeddial.SpeedDialActionItem;
import com.leinardi.android.speeddial.SpeedDialView;
import com.leinardi.android.speeddial.UiUtils;

public class FabWithLabelView
extends LinearLayout {
    private static final String TAG = FabWithLabelView.class.getSimpleName();
    private TextView mLabelTextView;
    private FloatingActionButton mFab;
    private CardView mLabelCardView;
    private boolean mIsLabelEnabled;
    @Nullable
    private SpeedDialActionItem mSpeedDialActionItem;
    @Nullable
    private SpeedDialView.OnActionSelectedListener mOnActionSelectedListener;
    private int mCurrentFabSize;
    private float mLabelCardViewElevation;
    @Nullable
    private Drawable mLabelCardViewBackground;

    public FabWithLabelView(Context context) {
        super(context);
        this.init(context, null);
    }

    public FabWithLabelView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public FabWithLabelView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    @SuppressLint(value={"RestrictedApi"})
    public void setVisibility(int visibility) {
        super.setVisibility(visibility);
        this.getFab().setVisibility(visibility);
        if (this.isLabelEnabled()) {
            this.getLabelBackground().setVisibility(visibility);
        }
    }

    public void setOrientation(int orientation) {
        super.setOrientation(orientation);
        this.setFabSize(this.mCurrentFabSize);
        if (orientation == 1) {
            this.setLabelEnabled(false);
        } else {
            this.setLabel(this.mLabelTextView.getText().toString());
        }
    }

    public boolean isLabelEnabled() {
        return this.mIsLabelEnabled;
    }

    private void setLabelEnabled(boolean enabled) {
        this.mIsLabelEnabled = enabled;
        this.mLabelCardView.setVisibility(enabled ? 0 : 8);
    }

    public CardView getLabelBackground() {
        return this.mLabelCardView;
    }

    public FloatingActionButton getFab() {
        return this.mFab;
    }

    public SpeedDialActionItem getSpeedDialActionItem() {
        if (this.mSpeedDialActionItem == null) {
            throw new IllegalStateException("SpeedDialActionItem not set yet!");
        }
        return this.mSpeedDialActionItem;
    }

    public SpeedDialActionItem.Builder getSpeedDialActionItemBuilder() {
        return new SpeedDialActionItem.Builder(this.getSpeedDialActionItem());
    }

    public void setSpeedDialActionItem(SpeedDialActionItem actionItem) {
        int fabBackgroundColor;
        boolean imageTint;
        this.mSpeedDialActionItem = actionItem;
        if (actionItem.getFabType().equals("fill")) {
            FloatingActionButton newFab;
            this.removeView((View)this.mFab);
            View view = FabWithLabelView.inflate((Context)this.getContext(), (int)R.layout.sd_fill_fab, (ViewGroup)this);
            this.mFab = newFab = (FloatingActionButton)view.findViewById(R.id.sd_fab_fill);
        }
        this.setId(actionItem.getId());
        this.setLabel(actionItem.getLabel(this.getContext()));
        this.setFabContentDescription(actionItem.getContentDescription(this.getContext()));
        SpeedDialActionItem speedDialActionItem = this.getSpeedDialActionItem();
        this.setLabelClickable(speedDialActionItem != null && speedDialActionItem.isLabelClickable());
        this.setFabIcon(actionItem.getFabImageDrawable(this.getContext()));
        int imageTintColor = actionItem.getFabImageTintColor();
        if (imageTintColor == Integer.MIN_VALUE) {
            imageTintColor = UiUtils.getOnSecondaryColor(this.getContext());
        }
        if (imageTint = actionItem.getFabImageTint()) {
            this.setFabImageTintColor(imageTintColor);
        }
        if ((fabBackgroundColor = actionItem.getFabBackgroundColor()) == Integer.MIN_VALUE) {
            fabBackgroundColor = UiUtils.getPrimaryColor(this.getContext());
        }
        this.setFabBackgroundColor(fabBackgroundColor);
        int labelColor = actionItem.getLabelColor();
        if (labelColor == Integer.MIN_VALUE) {
            labelColor = ResourcesCompat.getColor((Resources)this.getResources(), (int)R.color.sd_label_text_color, (Resources.Theme)this.getContext().getTheme());
        }
        this.setLabelColor(labelColor);
        int labelBackgroundColor = actionItem.getLabelBackgroundColor();
        if (labelBackgroundColor == Integer.MIN_VALUE) {
            labelBackgroundColor = ResourcesCompat.getColor((Resources)this.getResources(), (int)R.color.sd_label_background_color, (Resources.Theme)this.getContext().getTheme());
        }
        this.setLabelBackgroundColor(labelBackgroundColor);
        if (actionItem.getFabSize() == -1 || actionItem.getFabType().equals("fill")) {
            this.getFab().setSize(1);
        } else {
            this.getFab().setSize(actionItem.getFabSize());
        }
        this.setFabSize(actionItem.getFabSize());
    }

    public void setOnActionSelectedListener(@Nullable SpeedDialView.OnActionSelectedListener listener) {
        this.mOnActionSelectedListener = listener;
        if (this.mOnActionSelectedListener != null) {
            this.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    SpeedDialActionItem speedDialActionItem = FabWithLabelView.this.getSpeedDialActionItem();
                    if (FabWithLabelView.this.mOnActionSelectedListener != null && speedDialActionItem != null) {
                        if (speedDialActionItem.isLabelClickable()) {
                            UiUtils.performTap((View)FabWithLabelView.this.getLabelBackground());
                        } else {
                            UiUtils.performTap((View)FabWithLabelView.this.getFab());
                        }
                    }
                }
            });
            this.getFab().setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    SpeedDialActionItem speedDialActionItem = FabWithLabelView.this.getSpeedDialActionItem();
                    if (FabWithLabelView.this.mOnActionSelectedListener != null && speedDialActionItem != null) {
                        FabWithLabelView.this.mOnActionSelectedListener.onActionSelected(speedDialActionItem);
                    }
                }
            });
            this.getLabelBackground().setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    SpeedDialActionItem speedDialActionItem = FabWithLabelView.this.getSpeedDialActionItem();
                    if (FabWithLabelView.this.mOnActionSelectedListener != null && speedDialActionItem != null && speedDialActionItem.isLabelClickable()) {
                        FabWithLabelView.this.mOnActionSelectedListener.onActionSelected(speedDialActionItem);
                    }
                }
            });
        } else {
            this.getFab().setOnClickListener(null);
            this.getLabelBackground().setOnClickListener(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(Context context, @Nullable AttributeSet attrs) {
        View rootView = FabWithLabelView.inflate((Context)context, (int)R.layout.sd_fab_with_label_view, (ViewGroup)this);
        rootView.setFocusable(false);
        rootView.setFocusableInTouchMode(false);
        this.mFab = (FloatingActionButton)rootView.findViewById(R.id.sd_fab);
        this.mLabelTextView = (TextView)rootView.findViewById(R.id.sd_label);
        this.mLabelCardView = (CardView)rootView.findViewById(R.id.sd_label_container);
        this.setFabSize(1);
        this.setOrientation(0);
        this.setClipChildren(false);
        this.setClipToPadding(false);
        TypedArray attr2 = context.obtainStyledAttributes(attrs, R.styleable.FabWithLabelView, 0, 0);
        try {
            int src = attr2.getResourceId(R.styleable.FabWithLabelView_srcCompat, Integer.MIN_VALUE);
            if (src == Integer.MIN_VALUE) {
                src = attr2.getResourceId(R.styleable.FabWithLabelView_android_src, Integer.MIN_VALUE);
            }
            SpeedDialActionItem.Builder builder = new SpeedDialActionItem.Builder(this.getId(), src);
            String labelText = attr2.getString(R.styleable.FabWithLabelView_fabLabel);
            builder.setLabel(labelText);
            int fabBackgroundColor = UiUtils.getPrimaryColor(context);
            fabBackgroundColor = attr2.getColor(R.styleable.FabWithLabelView_fabBackgroundColor, fabBackgroundColor);
            builder.setFabBackgroundColor(fabBackgroundColor);
            int labelColor = Integer.MIN_VALUE;
            labelColor = attr2.getColor(R.styleable.FabWithLabelView_fabLabelColor, labelColor);
            builder.setLabelColor(labelColor);
            int labelBackgroundColor = Integer.MIN_VALUE;
            labelBackgroundColor = attr2.getColor(R.styleable.FabWithLabelView_fabLabelBackgroundColor, labelBackgroundColor);
            builder.setLabelBackgroundColor(labelBackgroundColor);
            boolean labelClickable = attr2.getBoolean(R.styleable.FabWithLabelView_fabLabelClickable, true);
            builder.setLabelClickable(labelClickable);
            this.setSpeedDialActionItem(builder.create());
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"Failure setting FabWithLabelView icon", (Throwable)e);
        }
        finally {
            attr2.recycle();
        }
    }

    private void setFabSize(int fabSize) {
        LinearLayout.LayoutParams rootLayoutParams;
        int normalFabSizePx = this.getContext().getResources().getDimensionPixelSize(R.dimen.sd_fab_normal_size);
        int miniFabSizePx = this.getContext().getResources().getDimensionPixelSize(R.dimen.sd_fab_mini_size);
        int fabSideMarginPx = this.getContext().getResources().getDimensionPixelSize(R.dimen.sd_fab_side_margin);
        int fabSizePx = fabSize == 0 ? normalFabSizePx : miniFabSizePx;
        LinearLayout.LayoutParams fabLayoutParams = (LinearLayout.LayoutParams)this.mFab.getLayoutParams();
        if (this.getOrientation() == 0) {
            rootLayoutParams = new LinearLayout.LayoutParams(-2, fabSizePx);
            rootLayoutParams.gravity = 0x800005;
            if (fabSize == 0) {
                int excessMargin = (normalFabSizePx - miniFabSizePx) / 2;
                fabLayoutParams.setMargins(fabSideMarginPx - excessMargin, 0, fabSideMarginPx - excessMargin, 0);
            } else {
                fabLayoutParams.setMargins(fabSideMarginPx, 0, fabSideMarginPx, 0);
            }
        } else {
            rootLayoutParams = new LinearLayout.LayoutParams(fabSizePx, -2);
            rootLayoutParams.gravity = 16;
            fabLayoutParams.setMargins(0, 0, 0, 0);
        }
        this.setLayoutParams((ViewGroup.LayoutParams)rootLayoutParams);
        this.mFab.setLayoutParams((ViewGroup.LayoutParams)fabLayoutParams);
        this.mCurrentFabSize = fabSize;
    }

    private void setFabIcon(@Nullable Drawable mDrawable) {
        this.mFab.setImageDrawable(mDrawable);
    }

    private void setLabel(@Nullable CharSequence sequence) {
        if (!TextUtils.isEmpty((CharSequence)sequence)) {
            this.mLabelTextView.setText(sequence);
            this.setLabelEnabled(this.getOrientation() == 0);
        } else {
            this.setLabelEnabled(false);
        }
    }

    private void setLabelClickable(boolean clickable) {
        this.getLabelBackground().setClickable(clickable);
        this.getLabelBackground().setFocusable(clickable);
        this.getLabelBackground().setEnabled(clickable);
    }

    private void setFabContentDescription(@Nullable CharSequence sequence) {
        if (!TextUtils.isEmpty((CharSequence)sequence)) {
            this.mFab.setContentDescription(sequence);
        }
    }

    private void setFabImageTintColor(@ColorInt int color2) {
        ImageViewCompat.setImageTintList((ImageView)this.mFab, (ColorStateList)ColorStateList.valueOf((int)color2));
    }

    private void setFabBackgroundColor(@ColorInt int color2) {
        this.mFab.setBackgroundTintList(ColorStateList.valueOf((int)color2));
    }

    private void setLabelColor(@ColorInt int color2) {
        this.mLabelTextView.setTextColor(color2);
    }

    private void setLabelBackgroundColor(@ColorInt int color2) {
        if (color2 == 0) {
            this.mLabelCardView.setCardBackgroundColor(0);
            if (Build.VERSION.SDK_INT >= 21) {
                this.mLabelCardViewElevation = this.mLabelCardView.getElevation();
                this.mLabelCardView.setElevation(0.0f);
            } else {
                this.mLabelCardView.setBackgroundColor(0);
                this.mLabelCardViewBackground = this.mLabelCardView.getBackground();
            }
        } else {
            this.mLabelCardView.setCardBackgroundColor(ColorStateList.valueOf((int)color2));
            if (Build.VERSION.SDK_INT >= 21) {
                if (this.mLabelCardViewElevation != 0.0f) {
                    this.mLabelCardView.setElevation(this.mLabelCardViewElevation);
                    this.mLabelCardViewElevation = 0.0f;
                }
            } else if (this.mLabelCardViewBackground != null) {
                if (Build.VERSION.SDK_INT >= 16) {
                    this.mLabelCardView.setBackground(this.mLabelCardViewBackground);
                } else {
                    this.mLabelCardView.setBackgroundDrawable(this.mLabelCardViewBackground);
                }
                this.mLabelCardViewBackground = null;
            }
        }
    }
}

