/*
 * Decompiled with CFR 0.152.
 */
package com.legstar.codegen.tasks;

import com.legstar.codegen.models.SourceToXsdCobolModel;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public abstract class SourceToXsdCobolTask
extends Task {
    private final Log _log = LogFactory.getLog(((Object)((Object)this)).getClass());
    private SourceToXsdCobolModel mModel;

    public void checkInput(boolean xsdFileNameMandatory, boolean namespaceMandatory) {
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)"checkInput started");
            this._log.debug((Object)("   Target namespace name    = " + this.getNamespace()));
            this._log.debug((Object)("   Target directory         = " + this.getTargetDir()));
            this._log.debug((Object)("   Target Xsd file name     = " + this.getTargetXsdFileName()));
        }
        if (this.getModel() == null) {
            throw new BuildException("You must specify a model");
        }
        if (this.getTargetDir() == null) {
            throw new BuildException("You must provide a target directory");
        }
        if (!this.getTargetDir().exists()) {
            throw new BuildException("Directory " + this.getTargetDir() + " does not exist");
        }
        if (!this.getTargetDir().isDirectory() || !this.getTargetDir().canWrite()) {
            throw new BuildException(this.getTargetDir() + " is not a directory or is not writable");
        }
        if (xsdFileNameMandatory) {
            if (this.getTargetXsdFileName() == null || this.getTargetXsdFileName().length() == 0) {
                throw new BuildException("You must provide a target xsd file name");
            }
            if (this.getTargetXsdFileName().contains(File.separator) || this.getTargetXsdFileName().contains("/")) {
                throw new BuildException("Xsd file name should not specify a path (use targetDir for path)");
            }
        }
        if (namespaceMandatory && (this.getNamespace() == null || this.getNamespace().length() == 0)) {
            throw new BuildException("You must specify an output XML schema namespace");
        }
        if (this.getNamespace() != null && this.getNamespace().length() > 0) {
            try {
                URI nURI = new URI(this.getNamespace());
                if (nURI.isOpaque()) {
                    throw new BuildException("Namespace " + this.getNamespace() + " is not a hierarchical URI");
                }
            }
            catch (URISyntaxException e) {
                throw new BuildException((Throwable)e);
            }
        }
    }

    public static String packageFromURI(URI namespaceURI) {
        int i;
        StringTokenizer t;
        Vector<String> v;
        StringBuilder result = new StringBuilder();
        URI nURI = namespaceURI.normalize();
        boolean firstToken = true;
        if (nURI.getHost() != null && nURI.getHost().length() != 0) {
            v = new Vector<String>();
            t = new StringTokenizer(nURI.getHost(), ".");
            while (t.hasMoreTokens()) {
                v.addElement(t.nextToken());
            }
            for (i = v.size(); i > 0; --i) {
                if (!firstToken) {
                    result.append('.');
                } else {
                    firstToken = false;
                }
                result.append((String)v.get(i - 1));
            }
        }
        if (nURI.getPath() != null && nURI.getPath().length() != 0) {
            v = new Vector();
            t = new StringTokenizer(nURI.getPath(), "/");
            while (t.hasMoreTokens()) {
                v.addElement(t.nextToken());
            }
            for (i = 0; i < v.size(); ++i) {
                String token = (String)v.get(i);
                if (token.equals(".") || token.equals("..")) continue;
                if (!firstToken) {
                    result.append('.');
                } else {
                    firstToken = false;
                }
                result.append((String)v.get(i));
            }
        }
        if (nURI.getFragment() != null && nURI.getFragment().length() != 0) {
            if (!firstToken) {
                result.append('.');
            } else {
                firstToken = false;
            }
            result.append(nURI.getFragment());
        }
        String s = result.toString().toLowerCase();
        StringBuilder sb = new StringBuilder();
        for (i = 0; i < s.length(); ++i) {
            Character c = Character.valueOf(s.charAt(i));
            if (Character.isJavaIdentifierPart(c.charValue()) || c.equals(Character.valueOf('.'))) {
                sb.append(c);
                continue;
            }
            sb.append("_");
        }
        return sb.toString();
    }

    public File getTargetDir() {
        return this.getModel().getTargetDir();
    }

    public void setTargetDir(File targetDir) {
        this.getModel().setTargetDir(targetDir);
    }

    public String getTargetXsdFileName() {
        return this.getModel().getTargetXsdFileName();
    }

    public void setTargetXsdFileName(String targetXsdFileName) {
        this.getModel().setTargetXsdFileName(targetXsdFileName);
    }

    public String getNamespace() {
        return this.getModel().getNamespace();
    }

    public void setNamespace(String namespace) {
        this.getModel().setNamespace(namespace);
    }

    public SourceToXsdCobolModel getModel() {
        return this.mModel;
    }

    public void setModel(SourceToXsdCobolModel model) {
        this.mModel = model;
    }
}

