/*
 * Decompiled with CFR 0.152.
 */
package com.lazerycode.selenium.repository;

import com.lazerycode.selenium.OS;
import com.lazerycode.selenium.repository.FileDetails;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import nu.xom.Builder;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.Nodes;
import nu.xom.ParsingException;
import org.apache.log4j.Logger;
import org.apache.maven.plugin.MojoFailureException;

public class RepositoryParser {
    private static final Logger LOG = Logger.getLogger(RepositoryParser.class);
    private Document repositoryMap;
    private ArrayList<OS> operatingSystemList;
    private Map<String, String> bitRates = new HashMap<String, String>();
    private Map<String, ArrayList<String>> getSpecificExecutableVersions = new HashMap<String, ArrayList<String>>();
    private boolean onlyGetLatestVersions = true;
    private boolean selectivelyParseDriverExecutableList = false;
    private HashMap<String, FileDetails> downloadableFileList = new HashMap();

    public RepositoryParser(InputStream repositoryMapLocation, ArrayList<OS> operatingSystems, boolean thirtyTwoBit, boolean sixtyFourBit, boolean onlyGetLatestVersions) throws MojoFailureException {
        Builder parser = new Builder();
        try {
            this.repositoryMap = parser.build(repositoryMapLocation);
        }
        catch (ParsingException pe) {
            throw new MojoFailureException(pe.getLocalizedMessage());
        }
        catch (IOException ioe) {
            throw new MojoFailureException(ioe.getLocalizedMessage());
        }
        this.operatingSystemList = operatingSystems;
        if (thirtyTwoBit) {
            this.bitRates.put("32bit", "[@thirtytwobit='true']");
        }
        LOG.info((Object)("Download 32bit binaries: " + thirtyTwoBit));
        if (sixtyFourBit) {
            this.bitRates.put("64bit", "[@sixtyfourbit='true']");
        }
        LOG.info((Object)("Download 64bit binaries: " + sixtyFourBit));
        this.onlyGetLatestVersions = onlyGetLatestVersions;
        LOG.info((Object)("Download Latest Versions Only: " + onlyGetLatestVersions));
        LOG.info((Object)" ");
    }

    public void specifySpecificExecutableVersions(Map<String, String> executableVersions) {
        this.selectivelyParseDriverExecutableList = true;
        this.onlyGetLatestVersions = false;
        for (Map.Entry<String, String> values : executableVersions.entrySet()) {
            if (!this.getSpecificExecutableVersions.containsKey(values.getKey())) {
                this.getSpecificExecutableVersions.put(values.getKey(), new ArrayList());
            }
            this.getSpecificExecutableVersions.get(values.getKey()).add(values.getValue());
        }
    }

    private Nodes getAllChildren(String xpath) {
        return this.repositoryMap.query(xpath + "/*");
    }

    private Nodes getAllRelevantDriverNodes() {
        Nodes availableDrivers = this.getAllChildren("/root");
        Nodes usedDrivers = new Nodes();
        block0: for (int currentDriver = 0; currentDriver < availableDrivers.size(); ++currentDriver) {
            String driverType = ((Element)availableDrivers.get(currentDriver)).getAttribute("id").getValue();
            if (this.selectivelyParseDriverExecutableList) {
                for (Map.Entry<String, ArrayList<String>> driverDetail : this.getSpecificExecutableVersions.entrySet()) {
                    if (!driverDetail.getKey().equalsIgnoreCase(driverType)) continue;
                    usedDrivers.append(availableDrivers.get(currentDriver));
                    continue block0;
                }
                continue;
            }
            usedDrivers.append(availableDrivers.get(currentDriver));
        }
        return usedDrivers;
    }

    private Nodes getHighestVersion(Nodes listOfVersions) {
        Nodes highestVersionsList = new Nodes();
        for (int j = 0; j < this.operatingSystemList.size(); ++j) {
            Node nodeToAdd = null;
            String highestVersion = null;
            OS operatingSystem = this.operatingSystemList.get(j);
            for (int i = 0; i < listOfVersions.size(); ++i) {
                if (listOfVersions.get(i).query("./" + operatingSystem.toString().toLowerCase()).size() <= 0) continue;
                String currentVersion = ((Element)listOfVersions.get(i)).getAttribute("id").getValue();
                if (highestVersion != null && currentVersion.compareTo(highestVersion) <= 0) continue;
                highestVersion = currentVersion;
                nodeToAdd = listOfVersions.get(i);
            }
            if (nodeToAdd == null) continue;
            highestVersionsList.append(nodeToAdd);
        }
        return highestVersionsList;
    }

    private Nodes getSpecificVersions(Nodes listOfVersions, String driverID) {
        Nodes filteredVersions = new Nodes();
        for (Map.Entry<String, ArrayList<String>> driverDetail : this.getSpecificExecutableVersions.entrySet()) {
            if (!driverDetail.getKey().equalsIgnoreCase(driverID)) continue;
            block1: for (int j = 0; j < listOfVersions.size(); ++j) {
                String currentVersion = ((Element)listOfVersions.get(j)).getAttribute("id").getValue();
                ArrayList<String> wantedVersions = driverDetail.getValue();
                for (int current = 0; current < wantedVersions.size(); ++current) {
                    if (!wantedVersions.get(current).equalsIgnoreCase(currentVersion)) continue;
                    filteredVersions.append(listOfVersions.get(j));
                    LOG.info((Object)("Found " + driverID + " version " + wantedVersions.get(current) + " in the repository map."));
                    continue block1;
                }
            }
        }
        return filteredVersions;
    }

    private Nodes getFilteredListOfVersionNodes(Nodes usedDrivers) {
        Nodes filteredVersions = new Nodes();
        if (this.selectivelyParseDriverExecutableList) {
            LOG.info((Object)"Parsing Specific Executable Versions Supplied...");
            LOG.info((Object)" ");
        }
        for (int i = 0; i < usedDrivers.size(); ++i) {
            Node node;
            String driverID = ((Element)usedDrivers.get(i)).getAttribute("id").getValue();
            Nodes availableVersions = this.getAllChildren("/root/driver[@id='" + driverID + "']");
            if (this.selectivelyParseDriverExecutableList) {
                Nodes specificVersions = this.getSpecificVersions(availableVersions, driverID);
                for (int specificVersion = 0; specificVersion < specificVersions.size(); ++specificVersion) {
                    node = specificVersions.get(specificVersion);
                    filteredVersions.append(node);
                }
                continue;
            }
            if (this.onlyGetLatestVersions) {
                if (availableVersions.size() <= 0) continue;
                Nodes highestVersions = this.getHighestVersion(availableVersions);
                for (int highestVersion = 0; highestVersion < highestVersions.size(); ++highestVersion) {
                    node = highestVersions.get(highestVersion);
                    filteredVersions.append(node);
                }
                continue;
            }
            for (int currentVersion = 0; currentVersion < availableVersions.size(); ++currentVersion) {
                filteredVersions.append(availableVersions.get(currentVersion));
            }
        }
        if (this.selectivelyParseDriverExecutableList) {
            LOG.info((Object)" ");
        }
        return filteredVersions;
    }

    private FileDetails extractFileInformation(Node downloadableZipInformation) throws MalformedURLException {
        FileDetails fileDownloadInformation = new FileDetails();
        fileDownloadInformation.setFileLocation(downloadableZipInformation.query("./filelocation").get(0).getValue());
        fileDownloadInformation.setHash(downloadableZipInformation.query("./hash").get(0).getValue());
        fileDownloadInformation.setHashType(downloadableZipInformation.query("./hashtype").get(0).getValue());
        return fileDownloadInformation;
    }

    private void addDownloadableFilesToList(Node node, String osString) throws MalformedURLException {
        osString = osString.toLowerCase();
        for (Map.Entry<String, String> bitRate : this.bitRates.entrySet()) {
            Nodes fileDetails = node.query("./" + osString + bitRate.getValue());
            String driverType = ((Element)node.getParent()).getAttribute("id").getValue();
            String driverVersion = ((Element)node).getAttribute("id").getValue();
            String extractionPath = driverType + File.separator + osString.toLowerCase() + File.separator + bitRate.getKey() + File.separator + driverVersion;
            if (fileDetails.size() <= 0) continue;
            this.downloadableFileList.put(extractionPath, this.extractFileInformation(fileDetails.get(0)));
        }
    }

    public HashMap<String, FileDetails> getFilesToDownload() throws MalformedURLException {
        Nodes usedVersions = this.getFilteredListOfVersionNodes(this.getAllRelevantDriverNodes());
        for (int selectedVersion = 0; selectedVersion < usedVersions.size(); ++selectedVersion) {
            for (int selectedOperatingSystem = 0; selectedOperatingSystem < this.operatingSystemList.size(); ++selectedOperatingSystem) {
                this.addDownloadableFilesToList(usedVersions.get(selectedVersion), this.operatingSystemList.get(selectedOperatingSystem).toString());
            }
        }
        return this.downloadableFileList;
    }
}

