/*
 * Decompiled with CFR 0.152.
 */
package com.lazerycode.selenium.download;

import com.lazerycode.selenium.download.CheckFileHash;
import com.lazerycode.selenium.download.HashType;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.Logger;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;

public class FileDownloader {
    private static final Logger LOG = Logger.getLogger(FileDownloader.class);
    private URL remoteFile;
    private String filename;
    private String expectedHash;
    private HashType expectedHashType;
    private String fileDownloadDirectory;
    private int readTimeout = 15000;
    private int connectTimeout = 15000;
    private int totalNumberOfRetryAttempts = 1;

    public FileDownloader(File downloadDirectory, int retries, int connectTimeout, int readTimeout) throws MojoFailureException {
        this.localFilePath(downloadDirectory);
        this.specifyTotalNumberOfRetryAttempts(retries);
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
    }

    private void specifyTotalNumberOfRetryAttempts(int retries) {
        if (retries < 1) {
            LOG.warn((Object)"Invalid number of retry attempts specified, defaulting to '1'...");
            this.totalNumberOfRetryAttempts = 1;
        } else {
            this.totalNumberOfRetryAttempts = retries;
        }
    }

    private void localFilePath(File downloadDirectory) throws MojoFailureException {
        if (!downloadDirectory.exists()) {
            downloadDirectory.mkdirs();
        }
        if (!downloadDirectory.isDirectory()) {
            throw new MojoFailureException("'" + downloadDirectory.getAbsolutePath() + "' is not a directory!");
        }
        this.fileDownloadDirectory = downloadDirectory.getAbsolutePath();
    }

    public boolean fileExistsAndIsValid(File fileToCheck) throws IOException, MojoExecutionException {
        if (fileToCheck.exists()) {
            CheckFileHash hashChecker = new CheckFileHash();
            hashChecker.hashDetails(this.expectedHash, this.expectedHashType);
            hashChecker.fileToCheck(fileToCheck);
            return hashChecker.hasAValidHash();
        }
        return false;
    }

    public void remoteURL(URL value) throws MojoExecutionException {
        this.remoteFile = value;
        this.filename = FilenameUtils.getName((String)value.getFile());
    }

    public void setHash(String hashValue, HashType hashType) {
        this.expectedHash = hashValue;
        this.expectedHashType = hashType;
    }

    public File downloadFile() throws IOException, MojoExecutionException {
        File fileToDownload = new File(this.fileDownloadDirectory + File.separator + this.filename);
        for (int n = 0; n < this.totalNumberOfRetryAttempts; ++n) {
            try {
                LOG.info((Object)("Downloading '" + this.filename + "'..."));
                FileUtils.copyURLToFile((URL)this.remoteFile, (File)fileToDownload, (int)this.connectTimeout, (int)this.readTimeout);
                LOG.info((Object)("Checking to see if downloaded copy of '" + fileToDownload.getName() + "' is valid."));
                if (!this.fileExistsAndIsValid(fileToDownload)) continue;
                return fileToDownload;
            }
            catch (IOException ex) {
                LOG.info((Object)("Problem downloading '" + fileToDownload.getName() + "'... " + ex.getLocalizedMessage()));
                if (n + 1 >= this.totalNumberOfRetryAttempts) continue;
                LOG.info((Object)("Trying to download'" + fileToDownload.getName() + "' again..."));
            }
        }
        LOG.error((Object)("Unable to successfully downloaded '" + fileToDownload.getName() + "'!"));
        throw new MojoExecutionException("Unable to successfully downloaded '" + fileToDownload.getName() + "'!");
    }
}

