/*
 * Decompiled with CFR 0.152.
 */
package com.lazerycode.selenium.download;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.log4j.Logger;

public class ExtractFilesFromZip {
    private static final Logger LOG = Logger.getLogger(ExtractFilesFromZip.class);

    public static boolean unzipFile(File downloadedZip, String extractedToFilePath, boolean overwriteFilesThatExist) throws IOException {
        Boolean filesExtracted = false;
        ZipFile zip = new ZipFile(downloadedZip);
        Enumeration<? extends ZipEntry> entries = zip.entries();
        while (entries.hasMoreElements()) {
            ZipEntry zipFileEntry = entries.nextElement();
            LOG.debug((Object)("Found: " + zipFileEntry.getName()));
            if (zipFileEntry.isDirectory()) {
                LOG.debug((Object)(zipFileEntry.getName() + " is a directory, moving to next file..."));
                LOG.debug((Object)" ");
                continue;
            }
            File extractedFile = new File(extractedToFilePath, zipFileEntry.getName());
            LOG.info((Object)("File '" + extractedFile.getName() + "' Exists: " + extractedFile.exists()));
            LOG.debug((Object)("Overwrite files that exist: " + overwriteFilesThatExist));
            if (extractedFile.exists() && !overwriteFilesThatExist) {
                LOG.debug((Object)("Skipping file: " + extractedFile.getName()));
                continue;
            }
            extractedFile.getParentFile().mkdirs();
            extractedFile.createNewFile();
            LOG.info((Object)("Extracting '" + extractedFile.getName() + "'..."));
            InputStream is = zip.getInputStream(zipFileEntry);
            FileOutputStream os = new FileOutputStream(extractedFile);
            while (is.available() > 0) {
                ((OutputStream)os).write(is.read());
            }
            ((OutputStream)os).close();
            is.close();
            extractedFile.setExecutable(true);
            if (!extractedFile.canExecute()) {
                LOG.warn((Object)("Unable to set the executable flag for '" + extractedFile.getName() + "'!"));
            }
            filesExtracted = true;
        }
        zip.close();
        return filesExtracted;
    }
}

