/*
 * Decompiled with CFR 0.152.
 */
package com.lazerycode.selenium.download;

import com.lazerycode.selenium.download.ExtractFilesFromZip;
import com.lazerycode.selenium.download.FileDownloader;
import com.lazerycode.selenium.repository.FileDetails;
import java.io.File;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.Logger;

public class DownloadHandler {
    private static final Logger LOG = Logger.getLogger(DownloadHandler.class);
    private File rootStandaloneServerDirectory;
    private File downloadedZipFileDirectory;
    private int fileDownloadRetryAttempts;
    private int fileDownloadConnectTimeout;
    private int fileDownloadReadTimeout;
    private Map<String, FileDetails> filesToDownload;
    private boolean overwriteFilesThatExist = false;

    public DownloadHandler(File rootStandaloneServerDirectory, File downloadedZipFileDirectory, int fileDownloadRetryAttempts, int fileDownloadConnectTimeout, int fileDownloadReadTimeout, Map<String, FileDetails> filesToDownload, boolean overwriteFilesThatExist) throws Exception {
        this.rootStandaloneServerDirectory = rootStandaloneServerDirectory;
        this.downloadedZipFileDirectory = downloadedZipFileDirectory;
        this.fileDownloadRetryAttempts = fileDownloadRetryAttempts;
        this.fileDownloadConnectTimeout = fileDownloadConnectTimeout;
        this.fileDownloadReadTimeout = fileDownloadReadTimeout;
        this.filesToDownload = filesToDownload;
        this.overwriteFilesThatExist = overwriteFilesThatExist;
    }

    public void getStandaloneExecutableFiles() throws Exception {
        LOG.info((Object)("Zip files will be downloaded to '" + this.downloadedZipFileDirectory.getAbsolutePath() + "'"));
        LOG.info((Object)("Standalone executable files will be extracted to '" + this.rootStandaloneServerDirectory + "'"));
        LOG.info((Object)" ");
        LOG.info((Object)"Preparing to download Selenium Standalone Executable Binaries...");
        LOG.info((Object)" ");
        File fileToUnzip = null;
        FileDownloader downloader = new FileDownloader(this.downloadedZipFileDirectory, this.fileDownloadRetryAttempts, this.fileDownloadConnectTimeout, this.fileDownloadReadTimeout);
        for (Map.Entry<String, FileDetails> fileToDownload : this.filesToDownload.entrySet()) {
            String extractionDirectory;
            downloader.remoteURL(fileToDownload.getValue().getFileLocation());
            downloader.setHash(fileToDownload.getValue().getHash(), fileToDownload.getValue().getHashType());
            LOG.info((Object)" ");
            String currentFileAbsolutePath = this.downloadedZipFileDirectory + File.separator + FilenameUtils.getName((String)fileToDownload.getValue().getFileLocation().getFile());
            LOG.info((Object)("Checking to see if zip file '" + currentFileAbsolutePath + "' already exists and is valid."));
            boolean existsAndIsValid = downloader.fileExistsAndIsValid(new File(currentFileAbsolutePath));
            fileToUnzip = !existsAndIsValid ? downloader.downloadFile() : new File(currentFileAbsolutePath);
            if (!ExtractFilesFromZip.unzipFile(fileToUnzip, extractionDirectory = this.rootStandaloneServerDirectory.getAbsolutePath() + File.separator + fileToDownload.getKey(), this.overwriteFilesThatExist)) continue;
            LOG.info((Object)("File(s) copied to " + extractionDirectory));
        }
    }
}

