/*
 * Decompiled with CFR 0.152.
 */
package com.lazerycode.selenium.download;

import com.lazerycode.selenium.download.HashType;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.log4j.Logger;
import org.apache.maven.plugin.MojoExecutionException;

public class CheckFileHash {
    private static final Logger LOG = Logger.getLogger(CheckFileHash.class);
    private HashType typeOfHash = null;
    private String expectedFileHash = null;
    private File fileToCheck = null;

    public void fileToCheck(File fileToCheck) throws FileNotFoundException {
        boolean doesFileExist = fileToCheck.exists();
        LOG.info((Object)("Zip File Exists: " + doesFileExist));
        if (!doesFileExist) {
            throw new FileNotFoundException(fileToCheck + " does not exist!");
        }
        this.fileToCheck = fileToCheck;
    }

    public void hashDetails(String hash, HashType hashType) {
        this.expectedFileHash = hash;
        this.typeOfHash = hashType;
    }

    public boolean hasAValidHash() throws IOException, MojoExecutionException {
        if (this.fileToCheck == null) {
            throw new MojoExecutionException("File to check has not been set!");
        }
        if (this.expectedFileHash == null || this.typeOfHash == null) {
            throw new MojoExecutionException("Hash details have not been set!");
        }
        if (!this.fileToCheck.exists()) {
            return false;
        }
        String actualFileHash = "";
        boolean isHashValid = false;
        LOG.info((Object)("Expected Hash: '" + this.expectedFileHash + "'"));
        switch (this.typeOfHash) {
            case MD5: {
                FileInputStream fileToHashCheck = new FileInputStream(this.fileToCheck);
                actualFileHash = DigestUtils.md5Hex((InputStream)fileToHashCheck);
                fileToHashCheck.close();
                if (!this.expectedFileHash.equals(actualFileHash)) break;
                isHashValid = true;
                break;
            }
            case SHA1: {
                FileInputStream fileToHashCheck = new FileInputStream(this.fileToCheck);
                actualFileHash = DigestUtils.shaHex((InputStream)fileToHashCheck);
                fileToHashCheck.close();
                if (!this.expectedFileHash.equals(actualFileHash)) break;
                isHashValid = true;
            }
        }
        LOG.info((Object)("Actual Hash: '" + actualFileHash + "'"));
        LOG.info((Object)("Hashes Match: " + isHashValid));
        return isHashValid;
    }
}

