/*
 * Decompiled with CFR 0.152.
 */
package com.lazerycode.selenium;

import com.lazerycode.selenium.MavenLoggerLog4jBridge;
import com.lazerycode.selenium.OS;
import com.lazerycode.selenium.download.DownloadHandler;
import com.lazerycode.selenium.repository.RepositoryParser;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Map;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.log4j.Appender;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Logger;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.xml.sax.SAXException;

public class SeleniumServerMojo
extends AbstractMojo {
    protected File rootStandaloneServerDirectory;
    protected File downloadedZipFileDirectory;
    protected File customRepositoryMap;
    protected Map<String, String> operatingSystems;
    protected boolean thirtyTwoBitBinaries;
    protected boolean sixtyFourBitBinaries;
    protected boolean onlyGetLatestVersions;
    protected Map<String, String> getSpecificExecutableVersions;
    protected int fileDownloadRetryAttempts;
    protected int fileDownloadConnectTimeout;
    protected int fileDownloadReadTimeout;
    protected boolean overwriteFilesThatExist;
    private InputStream xmlRepositoryMap = null;
    private static final Logger LOG = Logger.getLogger(SeleniumServerMojo.class);

    public void execute() throws MojoExecutionException, MojoFailureException {
        BasicConfigurator.configure((Appender)new MavenLoggerLog4jBridge(this.getLog()));
        LOG.info((Object)" ");
        LOG.info((Object)"--------------------------------------------------------");
        LOG.info((Object)" DOWNLOADING SELENIUM STAND-ALONE EXECUTABLE BINARIES...");
        LOG.info((Object)"--------------------------------------------------------");
        LOG.info((Object)" ");
        this.CheckRepositoryMapIsValid();
        this.SetRepositoryMapFile();
        RepositoryParser executableBinaryMapping = new RepositoryParser(this.xmlRepositoryMap, this.buildOSArrayList(this.operatingSystems), this.thirtyTwoBitBinaries, this.sixtyFourBitBinaries, this.onlyGetLatestVersions);
        if (this.getSpecificExecutableVersions != null && this.getSpecificExecutableVersions.size() > 0) {
            executableBinaryMapping.specifySpecificExecutableVersions(this.getSpecificExecutableVersions);
        }
        try {
            DownloadHandler standaloneExecutableDownloader = new DownloadHandler(this.rootStandaloneServerDirectory, this.downloadedZipFileDirectory, this.fileDownloadRetryAttempts, this.fileDownloadConnectTimeout, this.fileDownloadReadTimeout, executableBinaryMapping.getFilesToDownload(), this.overwriteFilesThatExist);
            standaloneExecutableDownloader.getStandaloneExecutableFiles();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to download all of the standalone executables: " + e.getLocalizedMessage());
        }
        LOG.info((Object)" ");
        LOG.info((Object)"--------------------------------------------------------");
        LOG.info((Object)" SELENIUM STAND-ALONE EXECUTABLE DOWNLOADS COMPLETE");
        LOG.info((Object)"--------------------------------------------------------");
        LOG.info((Object)" ");
    }

    private ArrayList<OS> buildOSArrayList(Map<String, String> operatingSystems) throws MojoExecutionException {
        ArrayList<OS> operatingSystemsSelected = new ArrayList<OS>();
        if (operatingSystems == null || operatingSystems.size() < 1) {
            for (OS selectedOS : OS.values()) {
                operatingSystemsSelected.add(selectedOS);
            }
        } else {
            for (Map.Entry<String, String> os : operatingSystems.entrySet()) {
                if (!os.getValue().toLowerCase().equals("true")) continue;
                try {
                    operatingSystemsSelected.add(OS.valueOf(os.getKey().toUpperCase()));
                }
                catch (IllegalArgumentException iae) {
                    throw new MojoExecutionException("'" + os.getKey().toUpperCase() + "' is not a known operating system.");
                }
            }
        }
        return operatingSystemsSelected;
    }

    private void SetRepositoryMapFile() throws MojoExecutionException {
        if (this.customRepositoryMap == null || !this.customRepositoryMap.exists()) {
            if (this.customRepositoryMap != null) {
                LOG.info((Object)"Unable to access the specified custom repository map, defaulting to bundled version...");
                LOG.info((Object)" ");
            }
            this.xmlRepositoryMap = ((Object)((Object)this)).getClass().getResourceAsStream("/RepositoryMap.xml");
        } else {
            try {
                this.xmlRepositoryMap = this.customRepositoryMap.toURI().toURL().openStream();
            }
            catch (IOException ioe) {
                throw new MojoExecutionException(ioe.getLocalizedMessage());
            }
        }
    }

    private void CheckRepositoryMapIsValid() throws MojoExecutionException {
        URL schemaFile = ((Object)((Object)this)).getClass().getResource("/RepositoryMap.xsd");
        StreamSource xmlFile = new StreamSource(this.customRepositoryMap);
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        try {
            Schema schema = schemaFactory.newSchema(schemaFile);
            Validator validator = schema.newValidator();
            validator.validate(xmlFile);
            LOG.info((Object)(xmlFile.getSystemId() + " is valid"));
        }
        catch (SAXException saxe) {
            throw new MojoExecutionException(this.customRepositoryMap.getName() + " is not valid: " + saxe.getLocalizedMessage());
        }
        catch (IOException ioe) {
            this.customRepositoryMap = null;
        }
    }
}

