/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.eventsource;

import com.launchdarkly.eventsource.ConnectStrategy;
import com.launchdarkly.eventsource.Helpers;
import com.launchdarkly.eventsource.ModernTLSSocketFactory;
import com.launchdarkly.eventsource.ResponseHeaders;
import com.launchdarkly.eventsource.ResponseHeadersImpl;
import com.launchdarkly.eventsource.StreamException;
import com.launchdarkly.eventsource.StreamHttpErrorException;
import com.launchdarkly.eventsource.StreamIOException;
import com.launchdarkly.logging.LDLogger;
import com.launchdarkly.logging.LogValues;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URI;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import okhttp3.Authenticator;
import okhttp3.Call;
import okhttp3.ConnectionPool;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class HttpConnectStrategy
extends ConnectStrategy {
    public static final long DEFAULT_CONNECT_TIMEOUT_MILLIS = 10000L;
    public static final long DEFAULT_WRITE_TIMEOUT_MILLIS = 5000L;
    public static final long DEFAULT_READ_TIMEOUT_MILLIS = 5000L;
    private static final Headers DEFAULT_HEADERS = new Headers.Builder().add("Accept", "text/event-stream").add("Cache-Control", "no-cache").build();
    final URI uri;
    private final ClientConfigurer clientConfigurer;
    private final OkHttpClient httpClient;
    private final RequestTransformer requestTransformer;

    HttpConnectStrategy(URI uri) {
        this(uri, null, null, null);
    }

    private HttpConnectStrategy(URI uri, ClientConfigurer clientConfigurer, OkHttpClient httpClient, RequestTransformer requestTransformer) {
        if (uri == null) {
            throw new IllegalArgumentException("URI must not be null");
        }
        if (!uri.getScheme().equals("http") && !uri.getScheme().equals("https")) {
            throw new IllegalArgumentException("URI scheme must be http or https");
        }
        this.uri = uri;
        this.httpClient = httpClient;
        this.clientConfigurer = clientConfigurer;
        this.requestTransformer = requestTransformer;
    }

    @Override
    public Client createClient(LDLogger logger) {
        return new Client(logger);
    }

    private HttpConnectStrategy addClientConfigurerAction(final ClientConfigurer addedAction) {
        if (addedAction == null) {
            return this;
        }
        ClientConfigurer compositeAction = this.clientConfigurer == null ? addedAction : new ClientConfigurer(){

            @Override
            public void configure(OkHttpClient.Builder builder) {
                HttpConnectStrategy.this.clientConfigurer.configure(builder);
                addedAction.configure(builder);
            }
        };
        return new HttpConnectStrategy(this.uri, compositeAction, this.httpClient, this.requestTransformer);
    }

    private HttpConnectStrategy addRequestTransformerAction(final RequestTransformer addedAction) {
        if (addedAction == null) {
            return this;
        }
        RequestTransformer compositeAction = this.requestTransformer == null ? addedAction : new RequestTransformer(){

            @Override
            public Request transformRequest(Request request) {
                return addedAction.transformRequest(HttpConnectStrategy.this.requestTransformer.transformRequest(request));
            }
        };
        return new HttpConnectStrategy(this.uri, this.clientConfigurer, this.httpClient, compositeAction);
    }

    public HttpConnectStrategy clientBuilderActions(ClientConfigurer configurer) {
        return this.addClientConfigurerAction(configurer);
    }

    public HttpConnectStrategy connectTimeout(final long connectTimeout, final TimeUnit timeUnit) {
        return this.addClientConfigurerAction(new ClientConfigurer(){

            @Override
            public void configure(OkHttpClient.Builder builder) {
                builder.connectTimeout(connectTimeout, Helpers.timeUnitOrDefault(timeUnit));
            }
        });
    }

    public HttpConnectStrategy header(final String name, final String value) {
        return this.addRequestTransformerAction(new RequestTransformer(){

            @Override
            public Request transformRequest(Request request) {
                Request.Builder builder = request.newBuilder();
                builder.header(name, value);
                return builder.build();
            }
        });
    }

    public HttpConnectStrategy headers(final Headers headers) {
        return this.addRequestTransformerAction(new RequestTransformer(){

            @Override
            public Request transformRequest(Request request) {
                Request.Builder builder = request.newBuilder();
                for (String name : headers.names()) {
                    builder.removeHeader(name);
                    for (String value : headers.values(name)) {
                        builder.addHeader(name, value);
                    }
                }
                return builder.build();
            }
        });
    }

    public HttpConnectStrategy httpClient(OkHttpClient httpClient) {
        return new HttpConnectStrategy(this.uri, this.clientConfigurer, httpClient, this.requestTransformer);
    }

    public HttpConnectStrategy methodAndBody(final String method, final RequestBody body) {
        return this.addRequestTransformerAction(new RequestTransformer(){

            @Override
            public Request transformRequest(Request request) {
                return request.newBuilder().method(method, body).build();
            }
        });
    }

    public HttpConnectStrategy proxy(final Proxy proxy) {
        return this.addClientConfigurerAction(new ClientConfigurer(){

            @Override
            public void configure(OkHttpClient.Builder builder) {
                builder.proxy(proxy);
            }
        });
    }

    public HttpConnectStrategy proxy(String proxyHost, int proxyPort) {
        return this.proxy(new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyHost, proxyPort)));
    }

    public HttpConnectStrategy proxyAuthenticator(final Authenticator proxyAuthenticator) {
        return this.addClientConfigurerAction(new ClientConfigurer(){

            @Override
            public void configure(OkHttpClient.Builder builder) {
                builder.proxyAuthenticator(proxyAuthenticator);
            }
        });
    }

    public HttpConnectStrategy readTimeout(final long readTimeout, final TimeUnit timeUnit) {
        return this.addClientConfigurerAction(new ClientConfigurer(){

            @Override
            public void configure(OkHttpClient.Builder builder) {
                builder.readTimeout(readTimeout, Helpers.timeUnitOrDefault(timeUnit));
            }
        });
    }

    public HttpConnectStrategy requestTransformer(RequestTransformer requestTransformer) {
        return this.addRequestTransformerAction(requestTransformer);
    }

    public HttpConnectStrategy uri(URI uri) {
        return new HttpConnectStrategy(uri, this.clientConfigurer, this.httpClient, this.requestTransformer);
    }

    public HttpConnectStrategy writeTimeout(final long writeTimeout, final TimeUnit timeUnit) {
        return this.addClientConfigurerAction(new ClientConfigurer(){

            @Override
            public void configure(OkHttpClient.Builder builder) {
                builder.writeTimeout(writeTimeout, Helpers.timeUnitOrDefault(timeUnit));
            }
        });
    }

    private static X509TrustManager defaultTrustManager() throws GeneralSecurityException {
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init((KeyStore)null);
        Object[] trustManagers = trustManagerFactory.getTrustManagers();
        if (trustManagers.length != 1 || !(trustManagers[0] instanceof X509TrustManager)) {
            throw new IllegalStateException("Unexpected default trust managers:" + Arrays.toString(trustManagers));
        }
        return (X509TrustManager)trustManagers[0];
    }

    public static interface RequestTransformer {
        public Request transformRequest(Request var1);
    }

    public static interface ClientConfigurer {
        public void configure(OkHttpClient.Builder var1);
    }

    class Client
    extends ConnectStrategy.Client {
        final OkHttpClient httpClient;
        private final LDLogger logger;

        Client(LDLogger logger) {
            this.logger = logger;
            this.httpClient = this.createHttpClient();
        }

        @Override
        public ConnectStrategy.Client.Result connect(String lastEventId) throws StreamException {
            Response response;
            this.logger.debug("Attempting to connect to SSE stream at {}", (Object)HttpConnectStrategy.this.uri);
            Request request = this.createRequest(lastEventId);
            Call call = this.httpClient.newCall(request);
            try {
                response = call.execute();
            }
            catch (IOException e) {
                this.logger.info("Connection failed: {}", LogValues.exceptionSummary((Throwable)e));
                throw new StreamIOException(e);
            }
            if (!response.isSuccessful()) {
                ResponseHeaders headers = ResponseHeadersImpl.fromOkHttpHeaders(response.headers());
                response.close();
                this.logger.info("Server returned HTTP error {}", (Object)response.code());
                throw new StreamHttpErrorException(response.code(), headers);
            }
            ResponseHeaders headers = ResponseHeadersImpl.fromOkHttpHeaders(response.headers());
            ResponseBody responseBody = response.body();
            return new ConnectStrategy.Client.Result(responseBody.byteStream(), HttpConnectStrategy.this.uri, new RequestCloser(call), headers);
        }

        @Override
        public void close() {
            OkHttpClient preconfiguredClient = HttpConnectStrategy.this.httpClient;
            if (preconfiguredClient == null) {
                if (this.httpClient.connectionPool() != null) {
                    this.httpClient.connectionPool().evictAll();
                }
                if (this.httpClient.dispatcher() != null) {
                    this.httpClient.dispatcher().cancelAll();
                    if (this.httpClient.dispatcher().executorService() != null) {
                        this.httpClient.dispatcher().executorService().shutdownNow();
                    }
                }
            }
        }

        @Override
        public boolean awaitClosed(long timeoutMillis) throws InterruptedException {
            long deadline = System.currentTimeMillis() + timeoutMillis;
            if (this.httpClient.dispatcher().executorService() != null) {
                long shutdownTimeoutMills = Math.max(0L, deadline - System.currentTimeMillis());
                if (!this.httpClient.dispatcher().executorService().awaitTermination(shutdownTimeoutMills, TimeUnit.MILLISECONDS)) {
                    return false;
                }
            }
            return true;
        }

        private OkHttpClient createHttpClient() {
            if (HttpConnectStrategy.this.httpClient != null) {
                return HttpConnectStrategy.this.httpClient;
            }
            OkHttpClient.Builder builder = new OkHttpClient.Builder().connectionPool(new ConnectionPool(1, 1L, TimeUnit.SECONDS)).connectTimeout(10000L, TimeUnit.MILLISECONDS).readTimeout(5000L, TimeUnit.MILLISECONDS).writeTimeout(5000L, TimeUnit.MILLISECONDS).retryOnConnectionFailure(false);
            try {
                builder.sslSocketFactory((SSLSocketFactory)new ModernTLSSocketFactory(), HttpConnectStrategy.defaultTrustManager());
            }
            catch (GeneralSecurityException generalSecurityException) {
                // empty catch block
            }
            if (HttpConnectStrategy.this.clientConfigurer != null) {
                HttpConnectStrategy.this.clientConfigurer.configure(builder);
            }
            return builder.build();
        }

        @Override
        public URI getOrigin() {
            return HttpConnectStrategy.this.uri;
        }

        private Request createRequest(String lastEventId) {
            Request.Builder baseBuilder = new Request.Builder().url(HttpUrl.get((URI)HttpConnectStrategy.this.uri)).headers(DEFAULT_HEADERS);
            if (lastEventId != null && !lastEventId.isEmpty()) {
                baseBuilder.addHeader("Last-Event-ID", lastEventId);
            }
            return HttpConnectStrategy.this.requestTransformer == null ? baseBuilder.build() : HttpConnectStrategy.this.requestTransformer.transformRequest(baseBuilder.build());
        }
    }

    private static class RequestCloser
    implements Closeable {
        private final Call call;

        RequestCloser(Call call) {
            this.call = call;
        }

        @Override
        public void close() throws IOException {
            this.call.cancel();
        }
    }
}

