/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.eventsource;

import com.launchdarkly.eventsource.Helpers;
import com.launchdarkly.eventsource.RetryDelayStrategy;
import java.security.SecureRandom;
import java.util.concurrent.TimeUnit;

public class DefaultRetryDelayStrategy
extends RetryDelayStrategy {
    public static final long DEFAULT_MAX_DELAY_MILLIS = 30000L;
    public static final float DEFAULT_BACKOFF_MULTIPLIER = 2.0f;
    public static final float DEFAULT_JITTER_MULTIPLIER = 0.5f;
    static DefaultRetryDelayStrategy INSTANCE = new DefaultRetryDelayStrategy(0L, 30000L, 2.0f, 0.5f);
    private final long lastBaseDelayMillis;
    private final long maxDelayMillis;
    private final float backoffMultiplier;
    private final float jitterMultiplier;
    private static final SecureRandom random = new SecureRandom();

    public DefaultRetryDelayStrategy maxDelay(long maxDelay, TimeUnit timeUnit) {
        return new DefaultRetryDelayStrategy(this.lastBaseDelayMillis, Helpers.millisFromTimeUnit(maxDelay, timeUnit), this.backoffMultiplier, this.jitterMultiplier);
    }

    public DefaultRetryDelayStrategy backoffMultiplier(float newBackoffMultiplier) {
        return new DefaultRetryDelayStrategy(0L, this.maxDelayMillis, newBackoffMultiplier, this.jitterMultiplier);
    }

    public DefaultRetryDelayStrategy jitterMultiplier(float newJitterMultiplier) {
        return new DefaultRetryDelayStrategy(0L, this.maxDelayMillis, this.backoffMultiplier, newJitterMultiplier);
    }

    private DefaultRetryDelayStrategy(long lastBaseDelayMillis, long maxDelayMillis, float backoffMultiplier, float jitterMultiplier) {
        this.lastBaseDelayMillis = lastBaseDelayMillis;
        this.maxDelayMillis = maxDelayMillis;
        this.backoffMultiplier = backoffMultiplier;
        this.jitterMultiplier = jitterMultiplier;
    }

    @Override
    public RetryDelayStrategy.Result apply(long baseDelayMillis) {
        int maxTimeInt;
        int jitterRange;
        long nextBaseDelay;
        long l = nextBaseDelay = this.lastBaseDelayMillis == 0L ? baseDelayMillis : (long)((float)this.lastBaseDelayMillis * this.backoffMultiplier);
        if (this.maxDelayMillis > 0L && nextBaseDelay > this.maxDelayMillis) {
            nextBaseDelay = this.maxDelayMillis;
        }
        long adjustedDelay = nextBaseDelay;
        if (this.jitterMultiplier > 0.0f && (jitterRange = Math.round((float)(maxTimeInt = nextBaseDelay > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)nextBaseDelay) * this.jitterMultiplier)) > 0) {
            adjustedDelay -= (long)random.nextInt(jitterRange);
        }
        DefaultRetryDelayStrategy updatedStrategy = new DefaultRetryDelayStrategy(nextBaseDelay, this.maxDelayMillis, this.backoffMultiplier, this.jitterMultiplier);
        return new RetryDelayStrategy.Result(adjustedDelay, updatedStrategy);
    }
}

