/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.eventsource;

import com.launchdarkly.eventsource.Logger;
import com.launchdarkly.logging.LDLogAdapter;
import com.launchdarkly.logging.LDLogLevel;
import com.launchdarkly.logging.LDLogger;
import com.launchdarkly.logging.SimpleFormat;

abstract class LoggerBridge {
    private LoggerBridge() {
    }

    static LDLogger wrapLogger(final Logger customLogger) {
        LDLogAdapter tempAdapter = new LDLogAdapter(){

            public LDLogAdapter.Channel newChannel(String name) {
                return new ChannelImpl(customLogger);
            }
        };
        return LDLogger.withAdapter((LDLogAdapter)tempAdapter, (String)"");
    }

    private static final class ChannelImpl
    implements LDLogAdapter.Channel {
        private final Logger wrappedLogger;

        ChannelImpl(Logger wrappedLogger) {
            this.wrappedLogger = wrappedLogger;
        }

        public void log(LDLogLevel level, String format, Object param1, Object param2) {
            String s = level == LDLogLevel.DEBUG ? null : SimpleFormat.format((String)format, (Object)param1, (Object)param2);
            switch (level) {
                case DEBUG: {
                    this.wrappedLogger.debug(format, param1, param2);
                }
                case INFO: {
                    this.wrappedLogger.info(s);
                }
                case WARN: {
                    this.wrappedLogger.warn(s);
                }
                case ERROR: {
                    this.wrappedLogger.error(s);
                }
            }
        }

        public void log(LDLogLevel level, String format, Object ... params) {
            String s = SimpleFormat.format((String)format, (Object[])params);
            switch (level) {
                case DEBUG: {
                    this.wrappedLogger.debug(s, null);
                }
                case INFO: {
                    this.wrappedLogger.info(s);
                }
                case WARN: {
                    this.wrappedLogger.warn(s);
                }
                case ERROR: {
                    this.wrappedLogger.error(s);
                }
            }
        }

        public void log(LDLogLevel level, String format, Object param) {
            String s = level == LDLogLevel.DEBUG ? null : SimpleFormat.format((String)format, (Object)param);
            switch (level) {
                case DEBUG: {
                    this.wrappedLogger.debug(format, param);
                }
                case INFO: {
                    this.wrappedLogger.info(s);
                }
                case WARN: {
                    this.wrappedLogger.warn(s);
                }
                case ERROR: {
                    this.wrappedLogger.error(s);
                }
            }
        }

        public void log(LDLogLevel level, Object message) {
            switch (level) {
                case DEBUG: {
                    this.wrappedLogger.debug("{}", message);
                }
                case INFO: {
                    this.wrappedLogger.info(message.toString());
                }
                case WARN: {
                    this.wrappedLogger.warn(message.toString());
                }
                case ERROR: {
                    this.wrappedLogger.error(message.toString());
                }
            }
        }

        public boolean isEnabled(LDLogLevel level) {
            return true;
        }
    }
}

