/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sse;

import com.launchdarkly.sse.AsyncEventHandler;
import com.launchdarkly.sse.ConnectionHandler;
import com.launchdarkly.sse.EventHandler;
import com.launchdarkly.sse.EventParser;
import com.launchdarkly.sse.MessageEvent;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import okhttp3.Headers;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okio.BufferedSource;
import okio.Okio;
import okio.Source;

public class EventSource
implements ConnectionHandler {
    public static final long DEFAULT_RECONNECT_TIME_MS = 2000L;
    public static final int CONNECTING = 0;
    public static final int OPEN = 1;
    public static final int CLOSED = 2;
    private final URI uri;
    private final Headers headers;
    private final ExecutorService executor;
    private volatile long reconnectTimeMs;
    private volatile String lastEventId;
    private final EventHandler handler;
    private AtomicInteger readyState;
    private final OkHttpClient client;

    EventSource(Builder builder) {
        this.uri = builder.uri;
        this.headers = EventSource.addDefaultHeaders(builder.headers);
        this.reconnectTimeMs = builder.reconnectTimeMs;
        this.handler = new AsyncEventHandler(builder.executor, builder.handler);
        this.readyState = new AtomicInteger(2);
        this.client = builder.client;
        this.executor = builder.executor;
    }

    public void start() {
        this.executor.submit(new Runnable(){

            public void run() {
                System.out.println("Connecting");
                EventSource.this.connect();
            }
        });
    }

    private void connect() {
        if (!this.readyState.compareAndSet(2, 0)) {
            return;
        }
        Request request = new Request.Builder().headers(this.headers).url(this.uri.toASCIIString()).get().build();
        try {
            Response response = this.client.newCall(request).execute();
            if (response.isSuccessful()) {
                String line;
                this.readyState.compareAndSet(0, 1);
                BufferedSource bs = Okio.buffer((Source)response.body().source());
                EventParser parser = new EventParser(this.uri, this.handler, this);
                while ((line = bs.readUtf8LineStrict()) != null) {
                    parser.line(line);
                }
            } else {
                this.readyState.compareAndSet(0, 2);
                response.body().close();
                this.reconnect();
            }
        }
        catch (IOException e) {
            this.handler.onError(e);
            this.readyState.compareAndSet(0, 2);
            this.reconnect();
        }
    }

    public void reconnect() {
        try {
            Thread.sleep(this.reconnectTimeMs);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.connect();
    }

    private static final Headers addDefaultHeaders(Headers custom) {
        Headers.Builder builder = new Headers.Builder();
        builder.add("Accept", "text/event-stream").add("Cache-Control", "no-cache");
        for (Map.Entry header : custom.toMultimap().entrySet()) {
            for (String value : (List)header.getValue()) {
                builder.add((String)header.getKey(), value);
            }
        }
        return builder.build();
    }

    public void setReconnectionTimeMs(long reconnectionTimeMs) {
        this.reconnectTimeMs = reconnectionTimeMs;
    }

    public void setLastEventId(String lastEventId) {
        this.lastEventId = lastEventId;
    }

    public static void main(String ... args) {
        EventHandler handler = new EventHandler(){

            public void onOpen() throws Exception {
                System.out.println("Open");
            }

            public void onMessage(String event, MessageEvent messageEvent) throws Exception {
                System.out.println(event + ": " + messageEvent.getData());
            }

            public void onError(Throwable t) {
                System.out.println("Error: " + t);
            }
        };
        EventSource source = new Builder(handler, URI.create("http://localhost:8080/events/")).build();
        source.start();
        System.out.println("exiting");
    }

    public static final class Builder {
        private ExecutorService executor = Executors.newCachedThreadPool();
        private long reconnectTimeMs = 2000L;
        private final URI uri;
        private final EventHandler handler;
        private Headers headers = Headers.of((String[])new String[0]);
        private OkHttpClient client = new OkHttpClient();

        public Builder(EventHandler handler, URI uri) {
            this.uri = uri;
            this.handler = handler;
        }

        public Builder executor(ExecutorService executor) {
            this.executor = executor;
            return this;
        }

        public Builder reconnectTimeMs(long reconnectTimeMs) {
            this.reconnectTimeMs = reconnectTimeMs;
            return this;
        }

        public Builder headers(Headers headers) {
            this.headers = headers;
            return this;
        }

        public Builder client(OkHttpClient client) {
            this.client = client;
            return this;
        }

        public EventSource build() {
            return new EventSource(this);
        }
    }
}

