/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.shaded.okio;

import com.launchdarkly.shaded.kotlin.Metadata;
import com.launchdarkly.shaded.kotlin.jvm.internal.Intrinsics;
import com.launchdarkly.shaded.okio.AsyncTimeout;
import com.launchdarkly.shaded.okio.Okio;
import com.launchdarkly.shaded.org.jetbrains.annotations.NotNull;
import com.launchdarkly.shaded.org.jetbrains.annotations.Nullable;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\tH\u0014J\b\u0010\u000b\u001a\u00020\fH\u0014R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/launchdarkly/shaded/okio/SocketAsyncTimeout;", "Lcom/launchdarkly/shaded/okio/AsyncTimeout;", "socket", "Ljava/net/Socket;", "(Ljava/net/Socket;)V", "logger", "Ljava/util/logging/Logger;", "com.launchdarkly.shaded.kotlin.jvm.PlatformType", "newTimeoutException", "Ljava/io/IOException;", "cause", "timedOut", "", "com.launchdarkly.shaded.okio"})
final class SocketAsyncTimeout
extends AsyncTimeout {
    private final Logger logger;
    private final Socket socket;

    @Override
    @NotNull
    protected IOException newTimeoutException(@Nullable IOException cause) {
        SocketTimeoutException ioe = new SocketTimeoutException("timeout");
        if (cause != null) {
            ioe.initCause(cause);
        }
        return ioe;
    }

    @Override
    protected void timedOut() {
        try {
            this.socket.close();
        }
        catch (Exception e) {
            this.logger.log(Level.WARNING, "Failed to close timed out socket " + this.socket, e);
        }
        catch (AssertionError e) {
            if (Okio.isAndroidGetsocknameError(e)) {
                this.logger.log(Level.WARNING, "Failed to close timed out socket " + this.socket, (Throwable)((Object)e));
            }
            throw (Throwable)((Object)e);
        }
    }

    public SocketAsyncTimeout(@NotNull Socket socket) {
        Intrinsics.checkParameterIsNotNull(socket, "socket");
        this.socket = socket;
        this.logger = Logger.getLogger("com.launchdarkly.shaded.okio.Okio");
    }
}

