/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.shaded.okhttp3.internal.platform;

import com.launchdarkly.shaded.kotlin.Metadata;
import com.launchdarkly.shaded.kotlin.TypeCastException;
import com.launchdarkly.shaded.kotlin.jvm.internal.DefaultConstructorMarker;
import com.launchdarkly.shaded.kotlin.jvm.internal.Intrinsics;
import com.launchdarkly.shaded.okhttp3.Protocol;
import com.launchdarkly.shaded.okhttp3.internal.platform.Platform;
import com.launchdarkly.shaded.org.bouncycastle.jsse.BCSSLParameters;
import com.launchdarkly.shaded.org.bouncycastle.jsse.BCSSLSocket;
import com.launchdarkly.shaded.org.bouncycastle.jsse.provider.BouncyCastleJsseProvider;
import com.launchdarkly.shaded.org.jetbrains.annotations.NotNull;
import com.launchdarkly.shaded.org.jetbrains.annotations.Nullable;
import java.security.KeyStore;
import java.security.Provider;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J-\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0011\u0010\u000b\u001a\r\u0012\t\u0012\u00070\r\u00a2\u0006\u0002\b\u000e0\fH\u0016J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/launchdarkly/shaded/okhttp3/internal/platform/BouncyCastlePlatform;", "Lcom/launchdarkly/shaded/okhttp3/internal/platform/Platform;", "()V", "provider", "Ljava/security/Provider;", "configureTlsExtensions", "", "sslSocket", "Ljavax/net/ssl/SSLSocket;", "hostname", "", "protocols", "", "Lcom/launchdarkly/shaded/okhttp3/Protocol;", "Lcom/launchdarkly/shaded/kotlin/jvm/JvmSuppressWildcards;", "getSelectedProtocol", "newSSLContext", "Ljavax/net/ssl/SSLContext;", "platformTrustManager", "Ljavax/net/ssl/X509TrustManager;", "trustManager", "sslSocketFactory", "Ljavax/net/ssl/SSLSocketFactory;", "Companion", "okhttp"})
public final class BouncyCastlePlatform
extends Platform {
    private final Provider provider = (Provider)new BouncyCastleJsseProvider();
    private static final boolean isSupported;
    public static final Companion Companion;

    @Override
    @NotNull
    public SSLContext newSSLContext() {
        SSLContext sSLContext = SSLContext.getInstance("TLS", this.provider);
        Intrinsics.checkExpressionValueIsNotNull(sSLContext, "SSLContext.getInstance(\"TLS\", provider)");
        return sSLContext;
    }

    @Override
    @NotNull
    public X509TrustManager platformTrustManager() {
        Object[] trustManagers;
        TrustManagerFactory factory2 = TrustManagerFactory.getInstance("PKIX", "BCJSSE");
        factory2.init((KeyStore)null);
        TrustManagerFactory trustManagerFactory = factory2;
        Intrinsics.checkExpressionValueIsNotNull(trustManagerFactory, "factory");
        Object[] objectArray = trustManagerFactory.getTrustManagers();
        if (objectArray == null) {
            Intrinsics.throwNpe();
        }
        boolean bl = (trustManagers = objectArray).length == 1 && trustManagers[0] instanceof X509TrustManager;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            Object[] objectArray2 = trustManagers;
            StringBuilder stringBuilder = new StringBuilder().append("Unexpected default trust managers: ");
            boolean bl5 = false;
            String string = Arrays.toString(objectArray2);
            Intrinsics.checkExpressionValueIsNotNull(string, "java.util.Arrays.toString(this)");
            String string2 = string;
            String string3 = stringBuilder.append(string2).toString();
            throw (Throwable)new IllegalStateException(string3.toString());
        }
        TrustManager trustManager = trustManagers[0];
        if (trustManager == null) {
            throw new TypeCastException("null cannot be cast to non-null type javax.net.ssl.X509TrustManager");
        }
        return (X509TrustManager)trustManager;
    }

    @Override
    @Nullable
    public X509TrustManager trustManager(@NotNull SSLSocketFactory sslSocketFactory) {
        Intrinsics.checkParameterIsNotNull(sslSocketFactory, "sslSocketFactory");
        throw (Throwable)new UnsupportedOperationException("clientBuilder.sslSocketFactory(SSLSocketFactory) not supported with BouncyCastle");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void configureTlsExtensions(@NotNull SSLSocket sslSocket, @Nullable String hostname, @NotNull List<Protocol> protocols) {
        Intrinsics.checkParameterIsNotNull(sslSocket, "sslSocket");
        Intrinsics.checkParameterIsNotNull(protocols, "protocols");
        if (sslSocket instanceof BCSSLSocket) {
            void $this$toTypedArray$iv;
            BCSSLParameters sslParameters = ((BCSSLSocket)sslSocket).getParameters();
            List<String> names = Platform.Companion.alpnProtocolNames(protocols);
            BCSSLParameters bCSSLParameters = sslParameters;
            Intrinsics.checkExpressionValueIsNotNull(bCSSLParameters, "sslParameters");
            Collection collection = names;
            BCSSLParameters bCSSLParameters2 = bCSSLParameters;
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv = $this$toTypedArray$iv;
            String[] stringArray = thisCollection$iv.toArray(new String[0]);
            if (stringArray == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            String[] stringArray2 = stringArray;
            bCSSLParameters2.setApplicationProtocols(stringArray2);
            ((BCSSLSocket)sslSocket).setParameters(sslParameters);
        } else {
            super.configureTlsExtensions(sslSocket, hostname, protocols);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public String getSelectedProtocol(@NotNull SSLSocket sslSocket) {
        void var2_2;
        String protocol;
        Intrinsics.checkParameterIsNotNull(sslSocket, "sslSocket");
        return sslSocket instanceof BCSSLSocket ? ((protocol = ((BCSSLSocket)sslSocket).getApplicationProtocol()) == null || Intrinsics.areEqual(protocol, "") ? null : var2_2) : super.getSelectedProtocol(sslSocket);
    }

    private BouncyCastlePlatform() {
    }

    static {
        boolean bl;
        Companion = new Companion(null);
        try {
            Class.forName("com.launchdarkly.shaded.org.bouncycastle.jsse.provider.BouncyCastleJsseProvider", false, Companion.getClass().getClassLoader());
            bl = true;
        }
        catch (ClassNotFoundException _) {
            bl = false;
        }
        isSupported = bl;
    }

    public /* synthetic */ BouncyCastlePlatform(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0005\u00a8\u0006\b"}, d2={"Lcom/launchdarkly/shaded/okhttp3/internal/platform/BouncyCastlePlatform$Companion;", "", "()V", "isSupported", "", "()Z", "buildIfSupported", "Lcom/launchdarkly/shaded/okhttp3/internal/platform/BouncyCastlePlatform;", "okhttp"})
    public static final class Companion {
        public final boolean isSupported() {
            return isSupported;
        }

        @Nullable
        public final BouncyCastlePlatform buildIfSupported() {
            return this.isSupported() ? new BouncyCastlePlatform(null) : null;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

