/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server;

import com.launchdarkly.logging.LDLogger;
import com.launchdarkly.sdk.server.FeatureRequestor;
import com.launchdarkly.sdk.server.HttpErrorException;
import com.launchdarkly.sdk.server.Util;
import com.launchdarkly.sdk.server.interfaces.DataSource;
import com.launchdarkly.sdk.server.interfaces.DataSourceStatusProvider;
import com.launchdarkly.sdk.server.interfaces.DataSourceUpdates;
import com.launchdarkly.sdk.server.interfaces.DataStoreTypes;
import com.launchdarkly.sdk.server.interfaces.SerializationException;
import com.launchdarkly.shaded.com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

final class PollingProcessor
implements DataSource {
    private static final String ERROR_CONTEXT_MESSAGE = "on polling request";
    private static final String WILL_RETRY_MESSAGE = "will retry at next scheduled poll interval";
    @VisibleForTesting
    final FeatureRequestor requestor;
    private final DataSourceUpdates dataSourceUpdates;
    private final ScheduledExecutorService scheduler;
    @VisibleForTesting
    final Duration pollInterval;
    private final AtomicBoolean initialized = new AtomicBoolean(false);
    private final CompletableFuture<Void> initFuture;
    private volatile ScheduledFuture<?> task;
    private final LDLogger logger;

    PollingProcessor(FeatureRequestor requestor, DataSourceUpdates dataSourceUpdates, ScheduledExecutorService sharedExecutor, Duration pollInterval, LDLogger logger) {
        this.requestor = requestor;
        this.dataSourceUpdates = dataSourceUpdates;
        this.scheduler = sharedExecutor;
        this.pollInterval = pollInterval;
        this.initFuture = new CompletableFuture();
        this.logger = logger;
    }

    @Override
    public boolean isInitialized() {
        return this.initialized.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        this.logger.info("Closing LaunchDarkly PollingProcessor");
        this.requestor.close();
        PollingProcessor pollingProcessor = this;
        synchronized (pollingProcessor) {
            if (this.task != null) {
                this.task.cancel(true);
                this.task = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Future<Void> start() {
        this.logger.info("Starting LaunchDarkly polling client with interval: {} milliseconds", (Object)this.pollInterval.toMillis());
        PollingProcessor pollingProcessor = this;
        synchronized (pollingProcessor) {
            if (this.task == null) {
                this.task = this.scheduler.scheduleAtFixedRate(this::poll, 0L, this.pollInterval.toMillis(), TimeUnit.MILLISECONDS);
            }
        }
        return this.initFuture;
    }

    private void poll() {
        try {
            boolean alreadyInited = this.initialized.get();
            DataStoreTypes.FullDataSet<DataStoreTypes.ItemDescriptor> allData = this.requestor.getAllData(!alreadyInited);
            if (allData == null) {
                this.dataSourceUpdates.updateStatus(DataSourceStatusProvider.State.VALID, null);
            } else if (this.dataSourceUpdates.init(allData)) {
                this.dataSourceUpdates.updateStatus(DataSourceStatusProvider.State.VALID, null);
                if (!this.initialized.getAndSet(true)) {
                    this.logger.info("Initialized LaunchDarkly client.");
                    this.initFuture.complete(null);
                }
            }
        }
        catch (HttpErrorException e) {
            DataSourceStatusProvider.ErrorInfo errorInfo = DataSourceStatusProvider.ErrorInfo.fromHttpError(e.getStatus());
            boolean recoverable = Util.checkIfErrorIsRecoverableAndLog(this.logger, Util.httpErrorDescription(e.getStatus()), ERROR_CONTEXT_MESSAGE, e.getStatus(), WILL_RETRY_MESSAGE);
            if (recoverable) {
                this.dataSourceUpdates.updateStatus(DataSourceStatusProvider.State.INTERRUPTED, errorInfo);
            } else {
                this.dataSourceUpdates.updateStatus(DataSourceStatusProvider.State.OFF, errorInfo);
                this.initFuture.complete(null);
                if (this.task != null) {
                    this.task.cancel(true);
                    this.task = null;
                }
            }
        }
        catch (IOException e) {
            Util.checkIfErrorIsRecoverableAndLog(this.logger, e.toString(), ERROR_CONTEXT_MESSAGE, 0, WILL_RETRY_MESSAGE);
            this.dataSourceUpdates.updateStatus(DataSourceStatusProvider.State.INTERRUPTED, DataSourceStatusProvider.ErrorInfo.fromException(DataSourceStatusProvider.ErrorKind.NETWORK_ERROR, e));
        }
        catch (SerializationException e) {
            this.logger.error("Polling request received malformed data: {}", (Object)e.toString());
            this.dataSourceUpdates.updateStatus(DataSourceStatusProvider.State.INTERRUPTED, DataSourceStatusProvider.ErrorInfo.fromException(DataSourceStatusProvider.ErrorKind.INVALID_DATA, e));
        }
        catch (Exception e) {
            this.logger.error("Unexpected error from polling processor: {}", (Object)e.toString());
            this.logger.debug(e.toString(), (Object)e);
            this.dataSourceUpdates.updateStatus(DataSourceStatusProvider.State.INTERRUPTED, DataSourceStatusProvider.ErrorInfo.fromException(DataSourceStatusProvider.ErrorKind.UNKNOWN, e));
        }
    }
}

