/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.shaded.org.apache.http.impl.client.cache.memcached;

import com.launchdarkly.shaded.org.apache.commons.codec.binary.Hex;
import com.launchdarkly.shaded.org.apache.commons.logging.Log;
import com.launchdarkly.shaded.org.apache.commons.logging.LogFactory;
import com.launchdarkly.shaded.org.apache.http.impl.client.cache.memcached.KeyHashingScheme;
import com.launchdarkly.shaded.org.apache.http.impl.client.cache.memcached.MemcachedKeyHashingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class SHA256KeyHashingScheme
implements KeyHashingScheme {
    private static final Log log = LogFactory.getLog(SHA256KeyHashingScheme.class);

    @Override
    public String hash(String key) {
        MessageDigest md = this.getDigest();
        md.update(key.getBytes());
        return Hex.encodeHexString(md.digest());
    }

    private MessageDigest getDigest() {
        try {
            return MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException nsae) {
            log.error("can't find SHA-256 implementation for cache key hashing");
            throw new MemcachedKeyHashingException(nsae);
        }
    }
}

