/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.client;

import com.launchdarkly.client.RedisFeatureStore;
import com.launchdarkly.shaded.org.apache.http.client.utils.URIBuilder;
import com.launchdarkly.shaded.redis.clients.jedis.JedisPoolConfig;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedisFeatureStoreBuilder {
    private static final Logger logger = LoggerFactory.getLogger(RedisFeatureStoreBuilder.class);
    protected boolean refreshStaleValues = false;
    protected boolean asyncRefresh = false;
    protected URI uri;
    protected String prefix;
    protected int connectTimeout = 2000;
    protected int socketTimeout = 2000;
    protected long cacheTimeSecs;
    protected JedisPoolConfig poolConfig;

    public RedisFeatureStoreBuilder(URI uri, long cacheTimeSecs) {
        this.uri = uri;
        this.cacheTimeSecs = cacheTimeSecs;
    }

    public RedisFeatureStoreBuilder(String scheme, String host, int port, long cacheTimeSecs) throws URISyntaxException {
        this.uri = new URIBuilder().setScheme(scheme).setHost(host).setPort(port).build();
        this.cacheTimeSecs = cacheTimeSecs;
    }

    public RedisFeatureStoreBuilder refreshStaleValues(boolean enabled) {
        this.refreshStaleValues = enabled;
        return this;
    }

    public RedisFeatureStoreBuilder asyncRefresh(boolean enabled) {
        this.asyncRefresh = enabled;
        return this;
    }

    public RedisFeatureStoreBuilder prefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    public RedisFeatureStoreBuilder cacheTime(long cacheTime, TimeUnit timeUnit) {
        this.cacheTimeSecs = timeUnit.toSeconds(cacheTime);
        return this;
    }

    public RedisFeatureStoreBuilder poolConfig(JedisPoolConfig poolConfig) {
        this.poolConfig = poolConfig;
        return this;
    }

    public RedisFeatureStoreBuilder connectTimeout(int connectTimeout, TimeUnit timeUnit) {
        this.connectTimeout = (int)timeUnit.toMillis(connectTimeout);
        return this;
    }

    public RedisFeatureStoreBuilder socketTimeout(int socketTimeout, TimeUnit timeUnit) {
        this.socketTimeout = (int)timeUnit.toMillis(socketTimeout);
        return this;
    }

    public RedisFeatureStore build() {
        logger.info("Creating RedisFeatureStore with uri: " + this.uri + " and prefix: " + this.prefix);
        return new RedisFeatureStore(this);
    }
}

