/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.client;

import com.launchdarkly.client.FeatureFlag;
import com.launchdarkly.client.FeatureFlagBuilder;
import com.launchdarkly.client.FeatureStore;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemoryFeatureStore
implements FeatureStore {
    private static final Logger logger = LoggerFactory.getLogger(InMemoryFeatureStore.class);
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final Map<String, FeatureFlag> features = new HashMap<String, FeatureFlag>();
    private volatile boolean initialized = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FeatureFlag get(String key) {
        try {
            this.lock.readLock().lock();
            FeatureFlag featureFlag = this.features.get(key);
            if (featureFlag == null) {
                logger.debug("[get] Key: " + key + " not found in feature store. Returning null");
                FeatureFlag featureFlag2 = null;
                return featureFlag2;
            }
            if (featureFlag.isDeleted()) {
                logger.debug("[get] Key: " + key + " has been deleted. Returning null");
                FeatureFlag featureFlag3 = null;
                return featureFlag3;
            }
            logger.debug("[get] Key: " + key + " with version: " + featureFlag.getVersion() + " found in feature store.");
            FeatureFlag featureFlag4 = featureFlag;
            return featureFlag4;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, FeatureFlag> all() {
        try {
            this.lock.readLock().lock();
            HashMap<String, FeatureFlag> fs = new HashMap<String, FeatureFlag>();
            for (Map.Entry<String, FeatureFlag> entry : this.features.entrySet()) {
                if (entry.getValue().isDeleted()) continue;
                fs.put(entry.getKey(), entry.getValue());
            }
            HashMap<String, FeatureFlag> hashMap = fs;
            return hashMap;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public void init(Map<String, FeatureFlag> features) {
        try {
            this.lock.writeLock().lock();
            this.features.clear();
            this.features.putAll(features);
            this.initialized = true;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(String key, int version) {
        try {
            this.lock.writeLock().lock();
            FeatureFlag f = this.features.get(key);
            if (f != null && f.getVersion() < version) {
                FeatureFlagBuilder newBuilder = new FeatureFlagBuilder(f);
                newBuilder.deleted(true);
                newBuilder.version(version);
                this.features.put(key, newBuilder.build());
            } else if (f == null) {
                f = new FeatureFlagBuilder(key).deleted(true).version(version).build();
                this.features.put(key, f);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void upsert(String key, FeatureFlag feature) {
        try {
            this.lock.writeLock().lock();
            FeatureFlag old = this.features.get(key);
            if (old == null || old.getVersion() < feature.getVersion()) {
                this.features.put(key, feature);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public boolean initialized() {
        return this.initialized;
    }

    @Override
    public void close() throws IOException {
    }
}

