/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.client;

import com.launchdarkly.client.FeatureFlag;
import com.launchdarkly.client.LDConfig;
import com.launchdarkly.client.Util;
import com.launchdarkly.shaded.org.apache.http.client.cache.CacheResponseStatus;
import com.launchdarkly.shaded.org.apache.http.client.cache.HttpCacheContext;
import com.launchdarkly.shaded.org.apache.http.client.config.RequestConfig;
import com.launchdarkly.shaded.org.apache.http.client.methods.CloseableHttpResponse;
import com.launchdarkly.shaded.org.apache.http.client.methods.HttpGet;
import com.launchdarkly.shaded.org.apache.http.client.methods.HttpUriRequest;
import com.launchdarkly.shaded.org.apache.http.impl.client.CloseableHttpClient;
import com.launchdarkly.shaded.org.apache.http.impl.client.cache.CacheConfig;
import com.launchdarkly.shaded.org.apache.http.impl.client.cache.CachingHttpClients;
import com.launchdarkly.shaded.org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import com.launchdarkly.shaded.org.apache.http.util.EntityUtils;
import java.io.Closeable;
import java.io.IOException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FeatureRequestor {
    public static final String GET_LATEST_FLAGS_PATH = "/sdk/latest-flags";
    private final String sdkKey;
    private final LDConfig config;
    private final CloseableHttpClient client;
    private static final Logger logger = LoggerFactory.getLogger(FeatureRequestor.class);

    FeatureRequestor(String sdkKey, LDConfig config) {
        this.sdkKey = sdkKey;
        this.config = config;
        this.client = this.createClient();
    }

    protected CloseableHttpClient createClient() {
        PoolingHttpClientConnectionManager manager = new PoolingHttpClientConnectionManager();
        manager.setMaxTotal(100);
        manager.setDefaultMaxPerRoute(20);
        CacheConfig cacheConfig = CacheConfig.custom().setMaxCacheEntries(1000).setMaxObjectSize(131072L).setSharedCache(false).build();
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(this.config.connectTimeout).setSocketTimeout(this.config.socketTimeout).setProxy(this.config.proxyHost).build();
        CloseableHttpClient client = CachingHttpClients.custom().setCacheConfig(cacheConfig).setConnectionManager(manager).setDefaultRequestConfig(requestConfig).build();
        return client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<String, FeatureFlag> getAllFlags() throws IOException {
        HttpCacheContext context = HttpCacheContext.create();
        HttpGet request = this.config.getRequest(this.sdkKey, GET_LATEST_FLAGS_PATH);
        Closeable response = null;
        try {
            logger.debug("Making request: " + request);
            response = this.client.execute((HttpUriRequest)request, context);
            this.logCacheResponse(context.getCacheResponseStatus());
            if (!Util.handleResponse(logger, request, (CloseableHttpResponse)response)) {
                throw new IOException("Failed to fetch flags");
            }
            String json = EntityUtils.toString(response.getEntity());
            logger.debug("Got response: " + response.toString());
            Map<String, FeatureFlag> map = FeatureFlag.fromJsonMap(json);
            return map;
        }
        finally {
            try {
                if (response != null) {
                    response.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    void logCacheResponse(CacheResponseStatus status) {
        switch (status) {
            case CACHE_HIT: {
                logger.debug("A response was generated from the cache with no requests sent upstream");
                break;
            }
            case CACHE_MODULE_RESPONSE: {
                logger.debug("The response was generated directly by the caching module");
                break;
            }
            case CACHE_MISS: {
                logger.debug("The response came from an upstream server");
                break;
            }
            case VALIDATED: {
                logger.debug("The response was generated from the cache after validating the entry with the origin server");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FeatureFlag getFlag(String featureKey) throws IOException {
        HttpCacheContext context = HttpCacheContext.create();
        HttpGet request = this.config.getRequest(this.sdkKey, "/sdk/latest-flags/" + featureKey);
        CloseableHttpResponse response = null;
        try {
            response = this.client.execute((HttpUriRequest)request, context);
            this.logCacheResponse(context.getCacheResponseStatus());
            if (!Util.handleResponse(logger, request, response)) {
                throw new IOException("Failed to fetch flag");
            }
            FeatureFlag featureFlag = FeatureFlag.fromJson(EntityUtils.toString(response.getEntity()));
            return featureFlag;
        }
        finally {
            try {
                if (response != null) {
                    response.close();
                }
            }
            catch (IOException iOException) {}
        }
    }
}

