/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.android;

import com.launchdarkly.logging.LDLogAdapter;
import com.launchdarkly.logging.LDLogLevel;
import com.launchdarkly.sdk.android.LDAndroidLogging;
import java.util.concurrent.atomic.AtomicBoolean;
import timber.log.Timber;

public abstract class LDTimberLogging {
    public static LDLogAdapter adapter() {
        return new Adapter(true);
    }

    public static final class Adapter
    implements LDLogAdapter,
    LDLogAdapter.IsConfiguredExternally {
        private final boolean autoPlantDebugTree;

        Adapter(boolean autoPlantDebugTree) {
            this.autoPlantDebugTree = autoPlantDebugTree;
        }

        public Adapter autoPlantDebugTree(boolean autoPlantDebugTree) {
            return new Adapter(autoPlantDebugTree);
        }

        public LDLogAdapter.Channel newChannel(String name) {
            return new ChannelImpl(name, this.autoPlantDebugTree);
        }
    }

    private static final class ChannelImpl
    extends LDAndroidLogging.ChannelImplBase {
        private static final AtomicBoolean inited = new AtomicBoolean(false);

        ChannelImpl(String tag, boolean autoPlantDebugTree) {
            super(tag);
            if (!autoPlantDebugTree || !inited.getAndSet(true)) {
                // empty if block
            }
        }

        public boolean isEnabled(LDLogLevel level) {
            return true;
        }

        @Override
        protected void logInternal(LDLogLevel level, String text) {
            Timber.Tree tree = Timber.tag((String)this.tag);
            switch (level) {
                case DEBUG: {
                    tree.d(text, new Object[0]);
                    break;
                }
                case INFO: {
                    tree.i(text, new Object[0]);
                    break;
                }
                case WARN: {
                    tree.w(text, new Object[0]);
                    break;
                }
                case ERROR: {
                    tree.e(text, new Object[0]);
                }
            }
        }
    }
}

