/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.android;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.launchdarkly.sdk.android.LDFailure;
import com.launchdarkly.sdk.android.LDInvalidResponseCodeFailure;
import java.lang.reflect.Type;

class LDFailureSerialization
implements JsonSerializer<LDFailure>,
JsonDeserializer<LDFailure> {
    LDFailureSerialization() {
    }

    public LDFailure deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject in = json.getAsJsonObject();
        LDFailure.FailureType failureType = (LDFailure.FailureType)((Object)context.deserialize(in.get("failureType"), LDFailure.FailureType.class));
        String message = in.getAsJsonPrimitive("message").getAsString();
        if (failureType == LDFailure.FailureType.UNEXPECTED_RESPONSE_CODE) {
            int responseCode = in.getAsJsonPrimitive("responseCode").getAsInt();
            boolean retryable = in.getAsJsonPrimitive("retryable").getAsBoolean();
            return new LDInvalidResponseCodeFailure(message, responseCode, retryable);
        }
        return new LDFailure(message, failureType);
    }

    public JsonElement serialize(LDFailure src, Type typeOfSrc, JsonSerializationContext context) {
        if (src == null) {
            return null;
        }
        JsonObject jsonObject = new JsonObject();
        jsonObject.add("failureType", context.serialize((Object)src.getFailureType()));
        jsonObject.addProperty("message", src.getMessage());
        if (src instanceof LDInvalidResponseCodeFailure) {
            LDInvalidResponseCodeFailure fail = (LDInvalidResponseCodeFailure)src;
            jsonObject.addProperty("responseCode", (Number)fail.getResponseCode());
            jsonObject.addProperty("retryable", Boolean.valueOf(fail.isRetryable()));
        }
        return jsonObject;
    }
}

