/*
 * Decompiled with CFR 0.152.
 */
package com.koverse.kdpapi.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"workspace", "datasetId", "partitions"})
@JsonTypeName(value="WriteBatchResponse")
public class WriteBatchResponse
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_WORKSPACE = "workspace";
    private String workspace;
    public static final String JSON_PROPERTY_DATASET_ID = "datasetId";
    private UUID datasetId;
    public static final String JSON_PROPERTY_PARTITIONS = "partitions";
    private Set<Integer> partitions = null;

    public WriteBatchResponse workspace(String workspace) {
        this.workspace = workspace;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ID of the workspace")
    @JsonProperty(value="workspace")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getWorkspace() {
        return this.workspace;
    }

    @JsonProperty(value="workspace")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setWorkspace(String workspace) {
        this.workspace = workspace;
    }

    public WriteBatchResponse datasetId(UUID datasetId) {
        this.datasetId = datasetId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ID of the dataset (uuid)")
    @JsonProperty(value="datasetId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UUID getDatasetId() {
        return this.datasetId;
    }

    @JsonProperty(value="datasetId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDatasetId(UUID datasetId) {
        this.datasetId = datasetId;
    }

    public WriteBatchResponse partitions(Set<Integer> partitions) {
        this.partitions = partitions;
        return this;
    }

    public WriteBatchResponse addPartitionsItem(Integer partitionsItem) {
        if (this.partitions == null) {
            this.partitions = new LinkedHashSet<Integer>();
        }
        this.partitions.add(partitionsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Array of integers (partitions)")
    @JsonProperty(value="partitions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Set<Integer> getPartitions() {
        return this.partitions;
    }

    @JsonDeserialize(as=LinkedHashSet.class)
    @JsonProperty(value="partitions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPartitions(Set<Integer> partitions) {
        this.partitions = partitions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WriteBatchResponse writeBatchResponse = (WriteBatchResponse)o;
        return Objects.equals(this.workspace, writeBatchResponse.workspace) && Objects.equals(this.datasetId, writeBatchResponse.datasetId) && Objects.equals(this.partitions, writeBatchResponse.partitions);
    }

    public int hashCode() {
        return Objects.hash(this.workspace, this.datasetId, this.partitions);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WriteBatchResponse {\n");
        sb.append("    workspace: ").append(this.toIndentedString(this.workspace)).append("\n");
        sb.append("    datasetId: ").append(this.toIndentedString(this.datasetId)).append("\n");
        sb.append("    partitions: ").append(this.toIndentedString(this.partitions)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

