/*
 * Decompiled with CFR 0.152.
 */
package com.koverse.kdpapi.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.koverse.kdpapi.client.model.WorkspaceSubscription;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"id", "uniqueId", "name", "userId", "subscription"})
@JsonTypeName(value="Workspace")
public class Workspace
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_UNIQUE_ID = "uniqueId";
    private UUID uniqueId;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_USER_ID = "userId";
    private String userId;
    public static final String JSON_PROPERTY_SUBSCRIPTION = "subscription";
    private WorkspaceSubscription subscription;

    public Workspace id(String id) {
        this.id = id;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="workspace ID")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setId(String id) {
        this.id = id;
    }

    public Workspace uniqueId(UUID uniqueId) {
        this.uniqueId = uniqueId;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="workspace unique ID for uniqueness check only")
    @JsonProperty(value="uniqueId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UUID getUniqueId() {
        return this.uniqueId;
    }

    @JsonProperty(value="uniqueId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setUniqueId(UUID uniqueId) {
        this.uniqueId = uniqueId;
    }

    public Workspace name(String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="workspace name")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(String name) {
        this.name = name;
    }

    public Workspace userId(String userId) {
        this.userId = userId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="user ID")
    @JsonProperty(value="userId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getUserId() {
        return this.userId;
    }

    @JsonProperty(value="userId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUserId(String userId) {
        this.userId = userId;
    }

    public Workspace subscription(WorkspaceSubscription subscription) {
        this.subscription = subscription;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="subscription")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public WorkspaceSubscription getSubscription() {
        return this.subscription;
    }

    @JsonProperty(value="subscription")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSubscription(WorkspaceSubscription subscription) {
        this.subscription = subscription;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Workspace workspace = (Workspace)o;
        return Objects.equals(this.id, workspace.id) && Objects.equals(this.uniqueId, workspace.uniqueId) && Objects.equals(this.name, workspace.name) && Objects.equals(this.userId, workspace.userId) && Objects.equals(this.subscription, workspace.subscription);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.uniqueId, this.name, this.userId, this.subscription);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Workspace {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    uniqueId: ").append(this.toIndentedString(this.uniqueId)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    userId: ").append(this.toIndentedString(this.userId)).append("\n");
        sb.append("    subscription: ").append(this.toIndentedString(this.subscription)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

